/*
 * Copyright 2005-2006 Portal Application Laboratory project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.pooptimizer;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import jp.sf.pal.facesresponse.io.BufferedResponseStream;
import jp.sf.pal.facesresponse.io.BufferedResponseStreamFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.bridges.portletfilter.PortletFilter;
import org.apache.portals.bridges.portletfilter.PortletFilterChain;
import org.apache.portals.bridges.portletfilter.PortletFilterConfig;

/**
 * @author shinsuke
 * 
 */
public class OptimizerFilter implements PortletFilter {
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(OptimizerFilter.class);

    private static final int DEFAULT_BLOCK_SIZE = 4096;

    private static final String BLOCK_SIZE_KEY = "block-size";

    private int blockSize = DEFAULT_BLOCK_SIZE;

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.portals.bridges.portletfilter.PortletFilter#destroy()
     */
    public void destroy() {

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.portals.bridges.portletfilter.PortletFilter#init(org.apache.portals.bridges.portletfilter.PortletFilterConfig)
     */
    public void init(PortletFilterConfig config) throws PortletException {
        String blockSizeStr = config.getInitParameter(BLOCK_SIZE_KEY);
        if (blockSizeStr != null) {
            try {
                blockSize = Integer.parseInt(blockSizeStr);
            } catch (NumberFormatException e) {
                log.warn("Could not parse " + blockSizeStr, e);
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.portals.bridges.portletfilter.PortletFilter#processActionFilter(javax.portlet.ActionRequest,
     *      javax.portlet.ActionResponse,
     *      org.apache.portals.bridges.portletfilter.PortletFilterChain)
     */
    public void processActionFilter(ActionRequest request,
            ActionResponse response, PortletFilterChain chain)
            throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("called processActionFilter.");
        }

        // call next processActionFilter
        chain.processActionFilter(request, response);

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.portals.bridges.portletfilter.PortletFilter#renderFilter(javax.portlet.RenderRequest,
     *      javax.portlet.RenderResponse,
     *      org.apache.portals.bridges.portletfilter.PortletFilterChain)
     */
    public void renderFilter(RenderRequest request, RenderResponse response,
            PortletFilterChain chain) throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("called renderFilter.");
        }

        // call next rednerFilter
        chain.renderFilter(request, response);

        BufferedResponseStream bufferedResponseStream = BufferedResponseStreamFactory
                .getBufferedResponseStream(request);
        if (bufferedResponseStream != null) {
            if (log.isDebugEnabled()) {
                log
                        .debug("renderFilter(RenderRequest, RenderResponse, PortletFilterChain) - bufferedResponseStream="
                                + bufferedResponseStream);
            }

            // just in case, commit it.
            bufferedResponseStream.commit();

            InputStream reader = bufferedResponseStream.getInputStream();
            BufferedOutputStream outputStream = new BufferedOutputStream(
                    bufferedResponseStream.getOutputStream());

            byte[] bytes = new byte[blockSize];
            try {
                int length = reader.read(bytes);
                if (length != -1) {
                    String str = new String(bytes, 0, length, "ISO-8859-1");
                    int beginBodyIndex = str.indexOf("<body");
                    if (beginBodyIndex == -1) {
                        beginBodyIndex = str.indexOf("<BODY");
                    }
                    if (beginBodyIndex >= 0) {
                        int beginBodyIndexEnd = str
                                .indexOf(">", beginBodyIndex);
                        int endBodyIndex = str.indexOf("</body");
                        if (endBodyIndex == -1) {
                            endBodyIndex = str.indexOf("</BODY");
                        }
                        if (endBodyIndex > beginBodyIndex) {
                            outputStream.write(bytes, beginBodyIndexEnd + 1,
                                    endBodyIndex - beginBodyIndexEnd - 1);
                        } else {
                            outputStream.write(bytes, beginBodyIndexEnd + 1,
                                    length - beginBodyIndexEnd - 1);
                            length = reader.read(bytes);
                            while (length != -1) {
                                str = new String(bytes, 0, length, "ISO-8859-1");
                                endBodyIndex = str.indexOf("</body");
                                if (endBodyIndex == -1) {
                                    endBodyIndex = str.indexOf("</BODY");
                                }
                                if (endBodyIndex >= 0) {
                                    outputStream.write(bytes, 0, endBodyIndex);
                                    break;
                                } else {
                                    if (length > 0) {
                                        outputStream.write(bytes, 0, length);
                                    }
                                    length = reader.read(bytes);
                                }
                            }
                        }
                    } else {
                        if (length != -1) {
                            outputStream.write(bytes, 0, length);
                        }
                        length = reader.read(bytes);
                        while (length != -1) {
                            str = new String(bytes, 0, length,
                                    bufferedResponseStream.getEncoding());
                            if (length > 0) {
                                outputStream.write(bytes, 0, length);
                            }
                            length = reader.read(bytes);
                        }
                    }
                }
                outputStream.flush();
            } finally {
                bytes = null;
            }

            bufferedResponseStream.commit();
        } else {
            if (log.isWarnEnabled()) {
                log.warn("BufferedResponseStream is null.");
            }
        }
    }

}
