/*
 * Copyright 2004-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.wiki.callback;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.faces.context.FacesContext;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;

import org.seasar.teeda.core.portlet.FacesPortlet;

import jp.sf.stconv.wiki.pipeline.callback.LinkGeneratorCallback;

/**
 * @author shinsuke
 * 
 */
public class WikiLinkGeneratorCallback implements LinkGeneratorCallback {

    private Map attributes;

    public WikiLinkGeneratorCallback() {
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.stconv.wiki.pipeline.callback.LinkGeneratorCallback#addAttribute(java.lang.String,
     *      java.lang.String)
     */
    public void addAttribute(String key, String value) {
        attributes.put(key, value);
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.stconv.wiki.pipeline.callback.LinkGeneratorCallback#getUrl()
     */
    public String getUrl() {
        Object r = FacesContext.getCurrentInstance().getExternalContext()
                .getResponse();
        if (r instanceof RenderResponse) {
            // PortletURL portletURL = ((RenderResponse) r).createActionURL();
            PortletURL portletURL = ((RenderResponse) r).createRenderURL();
            if (portletURL != null) {
                for (Iterator i = attributes.entrySet().iterator(); i.hasNext();) {
                    Map.Entry entry = (Map.Entry) i.next();
                    if (entry.getKey() != null && entry.getValue() != null) {
                        portletURL.setParameter((String) entry.getKey(),
                                (String) entry.getValue());
                    }
                }
                portletURL.setParameter(FacesPortlet.VIEW_ID, FacesContext
                        .getCurrentInstance().getViewRoot().getViewId());
                return portletURL.toString();
            }
        }
        return "";
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.stconv.wiki.pipeline.callback.LinkGeneratorCallback#init()
     */
    public void init() {
        if (attributes != null) {
            attributes.clear();
        } else {
            attributes = new HashMap();
        }
    }

}
