/*
 * Copyright 2004-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.wiki.web.viewer;

import jp.sf.pal.wiki.WikiConstants;
import jp.sf.pal.wiki.service.WikiContentService;

import org.seasar.framework.container.S2Container;

import jp.sf.pal.common.faces.application.FacesMessageUtil;

/**
 * @author shinsuke
 * 
 */
public class CreateNewNamePage {

    /**
     * 
     */
    private String pageName;

    private S2Container container;

    public CreateNewNamePage(S2Container container) {
        setContainer(container);
    }

    public String doCreateNewName() {
        if (pageName == null || pageName.equals("")) {
            // TODO i18n
            FacesMessageUtil.addErrorMessage("Invalid page name.");
            return WikiConstants.DISPLAY_CONTENT_HTMLPAGE;
        }

        WikiContentService contentService = (WikiContentService) container
                .getComponent(WikiContentService.class);
        contentService.setCurrentPageName(pageName);
        if (contentService.isPageName(pageName)) {
            return WikiConstants.EDIT_CONTENT_HTMLPAGE;
        }
        return WikiConstants.CREATE_NEW_CONTENT_HTMLPAGE;
    }

    /**
     * @return
     */
    public String initialize() {
        return null;
    }

    /**
     * @return
     */
    public String prerender() {
        return null;
    }

    /**
     * @return Returns the pageName.
     */
    public String getPageName() {
        return pageName;
    }

    /**
     * @param pageName
     *            The pageName to set.
     */
    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    /**
     * @return Returns the container.
     */
    public S2Container getContainer() {
        return container;
    }

    /**
     * @param container
     *            The container to set.
     */
    public void setContainer(S2Container container) {
        this.container = container;
    }

}
