/*
 * Copyright 2004-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.wiki.web.viewer;

import java.util.List;

import jp.sf.pal.wiki.service.WikiContentService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author shinsuke
 * 
 */
public class DisplayListPage {
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(DisplayListPage.class);

    /**
     * 
     */
    private List wikiPageItems;

    private WikiContentService wikiContentService;

    private String pageName;

    /**
     * @return Returns the wikiPageItems.
     */
    public List getWikiPageItems() {
        return wikiPageItems;
    }

    /**
     * @param wikiPageItems
     *            The wikiPageItems to set.
     */
    public void setWikiPageItems(List wikiPageItems) {
        this.wikiPageItems = wikiPageItems;
    }

    /**
     * @return
     */
    public String initialize() {
        return null;
    }

    /**
     * @return
     */
    public String prerender() {
        wikiPageItems = wikiContentService.getPages();
        return null;
    }

    /**
     * @return Returns the wikiContentService.
     */
    public WikiContentService getWikiContentService() {
        return wikiContentService;
    }

    /**
     * @param wikiContentService
     *            The wikiContentService to set.
     */
    public void setWikiContentService(WikiContentService wikiContentService) {
        this.wikiContentService = wikiContentService;
    }

    /**
     * @return Returns the title.
     */
    public String getPageName() {
        return pageName;
    }

    /**
     * @param title
     *            The title to set.
     */
    public void setPageName(String title) {
        this.pageName = title;
    }
}
