/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.converter.impl;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.seasar.extension.dxo.converter.ConversionContext;
import org.seasar.extension.dxo.converter.Converter;
import org.seasar.extension.dxo.converter.impl.AbstractConverter;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.exception.InstantiationRuntimeException;
import org.seasar.framework.util.ClassUtil;

public class BeanConverter
extends AbstractConverter {
    protected static final String JAVA = "java.";
    protected static final String JAVAX = "javax.";
    protected static final Object PROPERTY_NOT_FOUND = new Object();

    public Class[] getSourceClasses() {
        return new Class[]{Object.class};
    }

    public Class getDestClass() {
        return Object.class;
    }

    public Object convert(Object source, Class destClass, ConversionContext context) {
        if (source == null) {
            return null;
        }
        Class<?> sourceClass = source.getClass();
        if (destClass.isAssignableFrom(sourceClass)) {
            return source;
        }
        Object converted = context.getConvertedObject(source);
        if (converted != null) {
            return converted;
        }
        try {
            Object dest = ClassUtil.newInstance((Class)destClass);
            this.convert(source, dest, context);
            return dest;
        }
        catch (InstantiationRuntimeException ignore) {
            return null;
        }
    }

    public void convert(Object source, Object dest, ConversionContext context) {
        context.addConvertedObject(source, dest);
        this.setValues(source, dest, context);
    }

    protected void setValues(Object source, Object dest, ConversionContext context) {
        BeanDesc sourceBeanDesc = BeanDescFactory.getBeanDesc(source.getClass());
        BeanDesc destBeanDesc = BeanDescFactory.getBeanDesc(dest.getClass());
        for (int i = 0; i < destBeanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc destPropertyDesc = destBeanDesc.getPropertyDesc(i);
            if (!destPropertyDesc.hasWriteMethod()) continue;
            this.setValue(sourceBeanDesc, source, destBeanDesc, dest, destPropertyDesc, context);
        }
    }

    protected void setValue(BeanDesc sourceBeanDesc, Object source, BeanDesc destBeanDesc, Object dest, PropertyDesc destPropertyDesc, ConversionContext context) {
        String destPropertyName = destPropertyDesc.getPropertyName();
        Object sourcePropertyValue = this.getSourceValue(sourceBeanDesc, source, destPropertyName, context);
        if (sourcePropertyValue == PROPERTY_NOT_FOUND) {
            Object dateValue = this.getDateValue(sourceBeanDesc, source, destPropertyDesc);
            if (dateValue != null) {
                destPropertyDesc.setValue(dest, dateValue);
            }
            return;
        }
        if (sourcePropertyValue == null) {
            if (context.isIncludeNull()) {
                destPropertyDesc.setValue(dest, null);
            }
            return;
        }
        Class<?> sourcePropertyClass = sourcePropertyValue.getClass();
        Class destPropertyClass = destPropertyDesc.getPropertyType();
        Converter converter = this.getConverter(sourcePropertyClass, dest.getClass(), destPropertyClass, destPropertyName, context);
        Object convertedValue = converter.convert(sourcePropertyValue, destPropertyClass, context);
        destPropertyDesc.setValue(dest, convertedValue);
    }

    protected Object getSourceValue(BeanDesc sourceBeanDesc, Object source, String propertyName, ConversionContext context) {
        if (context.hasEvalueatedValue(propertyName)) {
            return context.getEvaluatedValue(propertyName);
        }
        if (sourceBeanDesc.hasPropertyDesc(propertyName)) {
            PropertyDesc sourcePropertyDesc = sourceBeanDesc.getPropertyDesc(propertyName);
            if (!sourcePropertyDesc.hasReadMethod()) {
                return PROPERTY_NOT_FOUND;
            }
            return sourcePropertyDesc.getValue(source);
        }
        return this.resolveNestedProperty(sourceBeanDesc, source, propertyName, context);
    }

    protected Object resolveNestedProperty(BeanDesc sourceBeanDesc, Object source, String propertyName, ConversionContext context) {
        for (int i = 0; i < sourceBeanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc nestedPropertyDesc;
            BeanDesc nestedBeanDesc;
            Object sourcePropertyValue;
            PropertyDesc propertyDesc = sourceBeanDesc.getPropertyDesc(i);
            Class propertyType = propertyDesc.getPropertyType();
            if (!propertyDesc.hasReadMethod() || this.isBasicType(propertyType) || (sourcePropertyValue = propertyDesc.getValue(source)) == null || !(nestedBeanDesc = BeanDescFactory.getBeanDesc((Class)propertyType)).hasPropertyDesc(propertyName) || !(nestedPropertyDesc = nestedBeanDesc.getPropertyDesc(propertyName)).hasReadMethod()) continue;
            return nestedPropertyDesc.getValue(sourcePropertyValue);
        }
        return PROPERTY_NOT_FOUND;
    }

    protected boolean isBasicType(Object object) {
        return this.isBasicType(object.getClass());
    }

    protected boolean isBasicType(Class clazz) {
        if (clazz.isPrimitive() || clazz.isArray()) {
            return true;
        }
        String className = clazz.getName();
        return className.startsWith(JAVA) || className.startsWith(JAVAX);
    }

    protected Object getDateValue(BeanDesc sourceBeanDesc, Object source, PropertyDesc destPropertyDesc) {
        Date dateValue;
        String destPropertyName = destPropertyDesc.getPropertyName();
        Class destPropertyType = destPropertyDesc.getPropertyType();
        if (destPropertyType == String.class) {
            return this.getDateValueAsString(sourceBeanDesc, source, destPropertyName);
        }
        if (Date.class.isAssignableFrom(destPropertyType) && (dateValue = this.getDateValueAsDate(sourceBeanDesc, source, destPropertyName)) != null) {
            if (destPropertyType.isAssignableFrom(Date.class)) {
                return dateValue;
            }
            if (destPropertyType.isAssignableFrom(java.sql.Date.class)) {
                return new java.sql.Date(dateValue.getTime());
            }
            if (destPropertyType.isAssignableFrom(Time.class)) {
                return new Time(dateValue.getTime());
            }
            if (destPropertyType.isAssignableFrom(Timestamp.class)) {
                return new Timestamp(dateValue.getTime());
            }
        }
        if (destPropertyType.isAssignableFrom(Calendar.class) && (dateValue = this.getDateValueAsDate(sourceBeanDesc, source, destPropertyName)) != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateValue);
            return calendar;
        }
        return null;
    }

    protected String getDateValueAsString(BeanDesc sourceBeanDesc, Object source, String destPropertyName) {
        PropertyDesc sourcePropertyDesc;
        Class sourcePropertyType;
        int pos = destPropertyName.lastIndexOf(95);
        if (pos == -1 || pos >= destPropertyName.length() - 1) {
            return null;
        }
        String sourcePropertyName = destPropertyName.substring(0, pos);
        if (!sourceBeanDesc.hasPropertyDesc(sourcePropertyName)) {
            return null;
        }
        if (!Date.class.isAssignableFrom(sourcePropertyType = (sourcePropertyDesc = sourceBeanDesc.getPropertyDesc(sourcePropertyName)).getPropertyType()) && !Calendar.class.isAssignableFrom(sourcePropertyType)) {
            return null;
        }
        Object sourceValue = sourcePropertyDesc.getValue(source);
        if (sourceValue == null) {
            return null;
        }
        String format = destPropertyName.substring(pos + 1);
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        if (sourceValue instanceof Date) {
            return formatter.format((Date)sourceValue);
        }
        if (sourceValue instanceof Calendar) {
            Calendar calendar = (Calendar)sourceValue;
            return formatter.format(new Date(calendar.getTimeInMillis()));
        }
        return null;
    }

    protected Date getDateValueAsDate(BeanDesc sourceBeanDesc, Object source, String destPropertyName) {
        String prefix = destPropertyName + "_";
        int starts = prefix.length();
        StringBuffer formatBuffer = new StringBuffer();
        StringBuffer valueBuffer = new StringBuffer();
        for (int i = 0; i < sourceBeanDesc.getPropertyDescSize(); ++i) {
            String sourcePropertyName;
            PropertyDesc sourcePropertyDesc = sourceBeanDesc.getPropertyDesc(i);
            if (sourcePropertyDesc.getPropertyType() != (class$java$lang$String == null ? BeanConverter.class$("java.lang.String") : class$java$lang$String) || !(sourcePropertyName = sourcePropertyDesc.getPropertyName()).startsWith(prefix)) continue;
            formatBuffer.append(sourcePropertyName.substring(starts));
            valueBuffer.append(sourcePropertyDesc.getValue(source));
        }
        String format = new String(formatBuffer);
        String stringValue = new String(valueBuffer);
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        try {
            return formatter.parse(stringValue);
        }
        catch (ParseException ignore) {
            return null;
        }
    }

    protected Converter getConverter(Class sourcePropertyClass, Class destClass, Class destPropertyClass, String destPropertyName, ConversionContext context) {
        Converter converter = context.getConverter(destClass, destPropertyName);
        if (converter != null) {
            return converter;
        }
        return context.getConverterFactory().getConverter(sourcePropertyClass, destPropertyClass);
    }
}

