/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.converter.impl;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.seasar.extension.dxo.converter.ConversionContext;
import org.seasar.extension.dxo.converter.impl.AbstractConverter;
import org.seasar.framework.util.StringUtil;

public class DateConverter
extends AbstractConverter {
    public Class[] getSourceClasses() {
        return new Class[]{Object.class};
    }

    public Class getDestClass() {
        return Date.class;
    }

    public Object convert(Object source, Class destClass, ConversionContext context) {
        DateFormat dateFormat;
        if (source == null) {
            return null;
        }
        if (source instanceof Date) {
            return source;
        }
        if (source instanceof Calendar) {
            return this.toDate((Calendar)source);
        }
        if (source instanceof Number) {
            return this.toDate((Number)source);
        }
        if (source instanceof String && (dateFormat = (DateFormat)context.getContextInfo("DATE_PATTERN")) != null) {
            return this.toDate((String)source, dateFormat);
        }
        return null;
    }

    protected Date toDate(Calendar calendar) {
        return calendar.getTime();
    }

    protected Date toDate(Number date) {
        return new Date(date.longValue());
    }

    protected Date toDate(String date, DateFormat dateFormat) {
        if (StringUtil.isEmpty((String)date)) {
            return null;
        }
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

