/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.converter.impl;

import java.math.BigDecimal;
import org.seasar.extension.dxo.converter.ConversionContext;
import org.seasar.extension.dxo.converter.impl.AbstractConverter;
import org.seasar.extension.dxo.exception.ConversionRuntimeException;
import org.seasar.framework.util.StringUtil;

public abstract class NumberConverter
extends AbstractConverter {
    protected static final Integer TRUE = new Integer(1);
    protected static final Integer FALSE = new Integer(0);

    public Class[] getSourceClasses() {
        return new Class[]{Number.class, CharSequence.class, Boolean.class, Object.class};
    }

    public Object convert(Object source, Class destClass, ConversionContext context) {
        if (source == null) {
            return null;
        }
        if (source instanceof Number) {
            return this.convert((Number)source);
        }
        if (source instanceof CharSequence) {
            return this.convert(source.toString());
        }
        if (source instanceof Boolean) {
            boolean b = (Boolean)source;
            if (b) {
                return this.convert(TRUE);
            }
            return this.convert(FALSE);
        }
        throw new ConversionRuntimeException(source.getClass());
    }

    protected abstract Number convert(Number var1);

    protected Number convert(String number) {
        if (StringUtil.isEmpty((String)number)) {
            return null;
        }
        BigDecimal decimal = new BigDecimal(number);
        return this.convert(decimal);
    }
}

