/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.converter.impl;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import org.seasar.extension.dxo.converter.ConversionContext;
import org.seasar.extension.dxo.converter.impl.AbstractConverter;

public class StringConverter
extends AbstractConverter {
    public Class[] getSourceClasses() {
        return new Class[]{Object.class};
    }

    public Class getDestClass() {
        return String.class;
    }

    public Object convert(Object source, Class destClass, ConversionContext context) {
        DateFormat formatter;
        if (source == null) {
            return null;
        }
        if (source instanceof String) {
            return source;
        }
        if (source instanceof char[]) {
            return new String((char[])source);
        }
        if (source instanceof java.sql.Date && (formatter = (DateFormat)context.getContextInfo("DATE_PATTERN")) != null) {
            return formatter.format((java.sql.Date)source);
        }
        if (source instanceof Time && (formatter = (DateFormat)context.getContextInfo("TIME_PATTERN")) != null) {
            return formatter.format((Time)source);
        }
        if (source instanceof Timestamp && (formatter = (DateFormat)context.getContextInfo("TIMESTAMP_PATTERN")) != null) {
            return formatter.format((Timestamp)source);
        }
        if (source instanceof Date && (formatter = (DateFormat)context.getContextInfo("DATE_PATTERN")) != null) {
            return formatter.format((Date)source);
        }
        if (source instanceof Calendar && (formatter = (DateFormat)context.getContextInfo("DATE_PATTERN")) != null) {
            return formatter.format(new Date(((Calendar)source).getTimeInMillis()));
        }
        return source.toString();
    }
}

