/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.ajax;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.PropertyNotFoundRuntimeException;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.MetaDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.servlet.S2ContainerServlet;
import org.seasar.teeda.ajax.AjaxConstants;
import org.seasar.teeda.ajax.AjaxUtil;

public class AjaxServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String AJAX_PREFIX = "ajax";
    private S2Container container;

    public void init(ServletConfig config) throws ServletException {
        this.container = S2ContainerServlet.getContainer();
        System.setErr(System.out);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doAjax(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doAjax(request, response);
    }

    protected void doAjax(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        MetaDef meta;
        ComponentDef def;
        String componentName = request.getParameter("component");
        String method = request.getParameter("action");
        if (method == null) {
            method = "ajaxAction";
        }
        if ((def = this.getComponentDefNoException(componentName)) == null) {
            throw new ServletException("Ajax Component Name[" + componentName + "] is not found.");
        }
        if (!method.startsWith(AJAX_PREFIX) && (meta = def.getMetaDef("teeda-ajax")) == null) {
            throw new ServletException("Ajax Component Name[" + componentName + "] is not public.");
        }
        Object obj = def.getComponent();
        if (obj == null) {
            throw new ServletException("Ajax Component Name[" + componentName + "] not found.");
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)def.getConcreteClass());
        if (!beanDesc.hasMethod(method)) {
            throw new ServletException("Ajax Component Name[" + componentName + "] does not has method[" + method + "]");
        }
        Object[] args = this.setRequestParameter(request, obj);
        Object target = null;
        try {
            target = beanDesc.invoke(obj, method, args);
        }
        catch (Exception e) {
            throw new ServletException("The error occurred while create Ajax response. " + e.getMessage());
        }
        String result = null;
        result = target instanceof String ? target.toString() : AjaxUtil.toJson(target);
        AjaxUtil.setContentType(response, result);
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        PrintWriter pw = response.getWriter();
        pw.write(result);
        pw.close();
    }

    protected Object[] setRequestParameter(HttpServletRequest request, Object obj) {
        Object[] args = null;
        TreeMap<Integer, String> ajaxParam = new TreeMap<Integer, String>();
        Enumeration enume = request.getParameterNames();
        while (enume.hasMoreElements()) {
            String key = (String)enume.nextElement();
            String value = request.getParameter(key);
            if (key.startsWith("AjaxParam")) {
                String index = key.substring(AjaxConstants.DEFAULT_ARRAY_PARAM_LENGTH);
                ajaxParam.put(new Integer(index), value);
                continue;
            }
            this.setPropertyNoException(obj, key, value);
        }
        int ajaxParamSize = ajaxParam.size();
        if (0 < ajaxParamSize) {
            args = new Object[ajaxParamSize];
            Iterator iterator = ajaxParam.keySet().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                args[i] = ajaxParam.get(iterator.next());
                ++i;
            }
        }
        return args;
    }

    protected void setPropertyNoException(Object target, String propertyName, String value) {
        try {
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(target.getClass());
            PropertyDesc propertyDesc = beanDesc.getPropertyDesc(propertyName);
            if ("".equals(value) && propertyDesc.getPropertyType() != String.class) {
                value = null;
            }
            propertyDesc.setValue(target, (Object)value);
        }
        catch (PropertyNotFoundRuntimeException e1) {
            // empty catch block
        }
    }

    protected ComponentDef getComponentDefNoException(String componentName) {
        if (!this.container.hasComponentDef((Object)componentName)) {
            return null;
        }
        return this.container.getComponentDef((Object)componentName);
    }
}

