/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.ajax;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

public class AjaxUtil {
    private static String contentTypeJson = null;
    private static String contentTypeXml = null;
    private static String contentTypeHtml = null;
    private static String contentTypeText = null;

    public static void clear() {
        contentTypeJson = null;
        contentTypeXml = null;
        contentTypeHtml = null;
        contentTypeText = null;
    }

    public static boolean isJSON(String str) {
        return str != null && str.startsWith("{") && str.endsWith("}");
    }

    public static void setContentType(HttpServletResponse response, String result) {
        String contentType = result == null || result.startsWith("{") && result.endsWith("}") ? (contentTypeJson == null ? "text/javascript; charset=UTF-8" : contentTypeJson) : (result.startsWith("<?xml") ? (contentTypeXml == null ? "text/xml; charset=UTF-8" : contentTypeXml) : (result.startsWith("<") && result.endsWith(">") ? (contentTypeHtml == null ? "text/html; charset=UTF-8" : contentTypeHtml) : (contentTypeText == null ? "text/plain; charset=UTF-8" : contentTypeText)));
        response.setContentType(contentType);
    }

    public static String toJson(Object o) {
        StringBuffer buf = new StringBuffer(100);
        AjaxUtil.append(buf, o);
        return buf.toString();
    }

    public static void append(StringBuffer buf, Object o) {
        if (o == null) {
            buf.append("null");
        } else if (o instanceof String) {
            buf.append(AjaxUtil.quote((String)o));
        } else if (o instanceof Float) {
            AjaxUtil.appendFloat(buf, (Float)o);
        } else if (o instanceof Double) {
            AjaxUtil.appendDouble(buf, (Double)o);
        } else if (o instanceof Number) {
            buf.append(o.toString());
        } else if (o instanceof Boolean) {
            AjaxUtil.appendBoolean(buf, (Boolean)o);
        } else if (o instanceof Collection) {
            AjaxUtil.appendArray(buf, ((Collection)o).toArray());
        } else if (o instanceof Object[]) {
            AjaxUtil.appendArray(buf, (Object[])o);
        } else if (o instanceof Map) {
            AjaxUtil.appendMap(buf, (Map)o);
        } else if (o.getClass().isArray()) {
            AjaxUtil.appendArray(buf, o);
        } else {
            AjaxUtil.appendBean(buf, o);
        }
    }

    public static void appendFloat(StringBuffer buf, Float f) {
        if (f.isNaN() || f.isInfinite()) {
            throw new IllegalArgumentException(f.toString());
        }
        buf.append(f.toString());
    }

    public static void appendDouble(StringBuffer buf, Double d) {
        if (d.isNaN() || d.isInfinite()) {
            throw new IllegalArgumentException(d.toString());
        }
        buf.append(d.toString());
    }

    public static void appendBoolean(StringBuffer buf, Boolean b) {
        if (Boolean.TRUE.equals(b)) {
            buf.append("true");
        } else {
            buf.append("false");
        }
    }

    public static void appendArray(StringBuffer buf, Object[] array) {
        int length = array.length;
        buf.append("[");
        for (int i = 0; i < length; ++i) {
            AjaxUtil.append(buf, array[i]);
            buf.append(",");
        }
        if (length > 0) {
            buf.setLength(buf.length() - 1);
        }
        buf.append("]");
    }

    public static void appendMap(StringBuffer buf, Map map) {
        buf.append("{");
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            buf.append(key + ":");
            AjaxUtil.append(buf, map.get(key));
            buf.append(",");
        }
        if (map.size() > 0) {
            buf.setLength(buf.length() - 1);
        }
        buf.append("}");
    }

    public static void appendBean(StringBuffer buf, Object bean) {
        buf.append("{");
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(bean.getClass());
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            buf.append(pd.getPropertyName() + ":");
            AjaxUtil.append(buf, pd.getValue(bean));
            buf.append(",");
        }
        if (beanDesc.getPropertyDescSize() > 0) {
            buf.setLength(buf.length() - 1);
        }
        buf.append("}");
    }

    public static void appendArray(StringBuffer buf, Object o) {
        int length = Array.getLength(o);
        buf.append("[");
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(o, i);
            AjaxUtil.append(buf, value);
            buf.append(",");
        }
        if (length > 0) {
            buf.setLength(buf.length() - 1);
        }
        buf.append("]");
    }

    public static String quote(String str) {
        if (str == null || str.length() == 0) {
            return "\"\"";
        }
        char current = '\u0000';
        int len = str.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block8: for (int i = 0; i < len; ++i) {
            current = str.charAt(i);
            switch (current) {
                case '\"': 
                case '/': 
                case '\\': {
                    sb.append('\\');
                    sb.append(current);
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                default: {
                    if (current < ' ') {
                        String t = "000" + Integer.toHexString(current);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block8;
                    }
                    sb.append(current);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static void setContentTypeJson(String contentTypeJson) {
        AjaxUtil.contentTypeJson = contentTypeJson;
    }

    public static void setContentTypeXml(String contentTypeXml) {
        AjaxUtil.contentTypeXml = contentTypeXml;
    }

    public static void setContentTypeHtml(String contentTypeHtml) {
        AjaxUtil.contentTypeHtml = contentTypeHtml;
    }

    public static void setContentTypeText(String contentTypeText) {
        AjaxUtil.contentTypeText = contentTypeText;
    }
}

