/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.mock.servlet;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.seasar.framework.exception.ResourceNotFoundRuntimeException;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockHttpServletRequestImpl;
import org.seasar.framework.mock.servlet.MockRequestDispatcherImpl;
import org.seasar.framework.mock.servlet.MockServletContext;
import org.seasar.framework.util.EnumerationAdapter;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public class MockServletContextImpl
implements MockServletContext,
Serializable {
    private static final long serialVersionUID = -5626752218858278823L;
    public static final int MAJOR_VERSION = 2;
    public static final int MINOR_VERSION = 4;
    public static final String SERVER_INFO = "seasar/2.0";
    private String servletContextName;
    private final Map mimeTypes = new HashMap();
    private final Map initParameters = new HashMap();
    private final Map attributes = new HashMap();

    public MockServletContextImpl(String path) {
        if (path == null || path.charAt(0) != '/') {
            path = "/";
        }
        this.servletContextName = path;
    }

    public ServletContext getContext(String path) {
        throw new UnsupportedOperationException();
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public String getMimeType(String file) {
        return (String)this.mimeTypes.get(file);
    }

    public void addMimeType(String file, String type) {
        this.mimeTypes.put(file, type);
    }

    public Set getResourcePaths(String path) {
        File file;
        File src = ResourceUtil.getResourceAsFile(".");
        File root = src.getParentFile();
        if (root.getName().equalsIgnoreCase("WEB-INF")) {
            root = root.getParentFile();
        }
        if (!(file = new File(root, this.adjustPath(path))).exists()) {
            String[] array = StringUtil.split(path, "/");
            if (array.length > 1) {
                path = array[array.length - 1];
            }
            do {
                file = new File(root, path);
                root = root.getParentFile();
            } while (!file.exists() && root != null);
        }
        if (file.isDirectory()) {
            HashSet<String> paths = new HashSet<String>();
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    paths.add("file:/" + files[i].getAbsolutePath());
                }
                return paths;
            }
        }
        return null;
    }

    public URL getResource(String path) throws MalformedURLException {
        if (ResourceUtil.isExist(path = this.adjustPath(path))) {
            return ResourceUtil.getResource(path);
        }
        return new URL(path);
    }

    public InputStream getResourceAsStream(String path) {
        if (ResourceUtil.isExist(path = this.adjustPath(path))) {
            return ResourceUtil.getResourceAsStream(path);
        }
        if (path.startsWith("WEB-INF")) {
            path = path.substring("WEB-INF".length());
            return this.getResourceAsStream(path);
        }
        return null;
    }

    protected String adjustPath(String path) {
        if (path != null && path.length() >= 0 && path.charAt(0) == '/') {
            return path.substring(1);
        }
        return path;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new MockRequestDispatcherImpl();
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        throw new UnsupportedOperationException();
    }

    public Servlet getServlet(String name) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public Enumeration getServlets() {
        throw new UnsupportedOperationException();
    }

    public Enumeration getServletNames() {
        throw new UnsupportedOperationException();
    }

    public void log(String message) {
        System.out.println(message);
    }

    public void log(Exception ex, String message) {
        System.out.println(message);
        ex.printStackTrace();
    }

    public void log(String message, Throwable t) {
        System.out.println(message);
        t.printStackTrace();
    }

    public String getRealPath(String path) {
        try {
            return ResourceUtil.getResource(this.adjustPath(path)).getFile();
        }
        catch (ResourceNotFoundRuntimeException e) {
            return null;
        }
    }

    public String getServerInfo() {
        return SERVER_INFO;
    }

    public String getInitParameter(String name) {
        return (String)this.initParameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        return new EnumerationAdapter(this.initParameters.keySet().iterator());
    }

    public void setInitParameter(String name, String value) {
        this.initParameters.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new EnumerationAdapter(this.attributes.keySet().iterator());
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getServletContextName() {
        return this.servletContextName;
    }

    public void setServletContextName(String servletContextName) {
        this.servletContextName = servletContextName;
    }

    public MockHttpServletRequest createRequest(String path) {
        String queryString = null;
        int question = path.indexOf(63);
        if (question >= 0) {
            queryString = path.substring(question + 1);
            path = path.substring(0, question);
        }
        MockHttpServletRequestImpl request = new MockHttpServletRequestImpl(this, path);
        request.setQueryString(queryString);
        return request;
    }

    public Map getInitParameterMap() {
        return this.initParameters;
    }
}

