/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.component;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.seasar.teeda.core.scope.impl.DispatchScope;
import org.seasar.teeda.core.scope.impl.DispatchScopeFactory;
import org.seasar.teeda.extension.util.JavaScriptContext;

public class ScriptEnhanceUIViewRoot
extends UIViewRoot {
    private static final String SCRIPTS_KEY = ScriptEnhanceUIViewRoot.class.getName() + ".SCRIPTS_KEY";
    private Map scriptsMap = new HashMap();

    public void addScript(String scriptId, JavaScriptContext jsContext) {
        Map scripts = this.getScriptsMap();
        if (!scripts.containsKey(scriptId)) {
            scripts.put(scriptId, jsContext);
        }
        this.scriptsMap.putAll(scripts);
    }

    public String getAllScripts() {
        StringBuffer buf = new StringBuffer();
        Iterator itr = this.scriptsMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            JavaScriptContext context = (JavaScriptContext)entry.getValue();
            if (!context.hasContext()) continue;
            buf.append(context.getResult());
        }
        return buf.toString();
    }

    public boolean containsScript(String scriptId) {
        return this.getScriptsMap().containsKey(scriptId);
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.scriptsMap = (Map)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.scriptsMap};
        return values;
    }

    protected Map getScriptsMap() {
        DispatchScope dispatchScope = this.getDispatchScope();
        HashMap scripts = (HashMap)dispatchScope.get((Object)SCRIPTS_KEY);
        if (scripts == null) {
            scripts = new HashMap();
            dispatchScope.put((Object)SCRIPTS_KEY, scripts);
        }
        return scripts;
    }

    protected DispatchScope getDispatchScope() {
        return DispatchScopeFactory.getDispatchScope();
    }
}

