/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.Map;
import javax.faces.internal.LabelUtil;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.factory.AbstractElementProcessorFactory;

public class OutputLabelFactory
extends AbstractElementProcessorFactory {
    private static final String TAG_NAME = "outputLabel";
    private NamingConvention namingConvention;

    public boolean isLeaf() {
        return true;
    }

    public boolean isMatch(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (!"label".equalsIgnoreCase(elementNode.getTagName())) {
            return false;
        }
        String id = elementNode.getId();
        return id != null;
    }

    protected void customizeProperties(Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        super.customizeProperties(properties, elementNode, pageDesc, actionDesc);
        if (pageDesc == null) {
            return;
        }
        String pageName = pageDesc.getPageName();
        String propertiesName = LabelUtil.getPropertiesName((NamingConvention)this.namingConvention, (String)pageName);
        String id = StringUtil.trimSuffix((String)elementNode.getId(), (String)"Label");
        String key = LabelUtil.getLabelKeySuffix((NamingConvention)this.namingConvention, (String)pageName) + "." + id;
        properties.put("key", key);
        properties.put("propertiesName", propertiesName);
        properties.put("defaultKey", id);
        String defaultPropertiesName = LabelUtil.getDefaultApplicationPropertiesName((NamingConvention)this.namingConvention, (String)pageName);
        properties.put("defaultPropertiesName", defaultPropertiesName);
    }

    protected void customizeDynamicProperty(String base, String name, Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        String propName;
        if (pageDesc == null) {
            return;
        }
        String pageName = pageDesc.getPageName();
        if (!StringUtil.isEmpty((String)base) && pageDesc.hasDynamicProperty(propName = base + "Value")) {
            properties.put("value", this.getBindingExpression(pageName, propName));
        }
    }

    protected String getTagName() {
        return TAG_NAME;
    }

    protected String getUri() {
        return "http://www.seasar.org/teeda/extension";
    }

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }
}

