/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.io.IOException;
import javax.faces.component.ActionSource;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.internal.scope.SubApplicationScope;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.log.Logger;
import org.seasar.teeda.core.application.ActionListenerImpl;
import org.seasar.teeda.core.util.DIContainerUtil;
import org.seasar.teeda.core.util.MethodBindingUtil;
import org.seasar.teeda.core.util.NavigationHandlerUtil;
import org.seasar.teeda.extension.exception.IllegalPageTransitionException;
import org.seasar.teeda.extension.util.PageTransitionUtil;

public class HtmlActionListener
extends ActionListenerImpl {
    private NamingConvention nc;
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static Logger logger = Logger.getLogger((Class)HtmlActionListener.class);

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        ActionSource actionSource = (ActionSource)actionEvent.getComponent();
        MethodBinding mb = actionSource.getAction();
        if (mb == null) {
            NavigationHandlerUtil.handleNoNavigation((FacesContext)context);
            context.renderResponse();
            return;
        }
        try {
            Class<?> pageClass;
            BeanDesc bd;
            Object component;
            String fromAction = mb.getExpressionString();
            String componentName = MethodBindingUtil.getComponentName((String)fromAction);
            String methodName = MethodBindingUtil.getMethodName((String)fromAction);
            if (componentName != null && methodName != null && (component = DIContainerUtil.getComponentNoException((Object)componentName)) != null && HtmlActionListener.isExtendReturnType(bd = BeanDescFactory.getBeanDesc(pageClass = component.getClass()), methodName)) {
                Class ret = (Class)bd.invoke(component, methodName, EMPTY_ARGS);
                String pageSuffix = this.nc.getPageSuffix();
                if (ret != null && !ret.getName().endsWith(pageSuffix)) {
                    throw new IllegalPageTransitionException(ret);
                }
                String outcome = PageTransitionUtil.getNextPageTransition(pageClass, ret, this.nc);
                this.processAfterInvoke(context, fromAction, outcome);
                NavigationHandlerUtil.handleNavigation((FacesContext)context, (String)fromAction, (String)outcome);
                context.renderResponse();
            }
        }
        catch (Exception e) {
            try {
                ExternalContext extContext = context.getExternalContext();
                if (!this.getErrorPageManager().handleException((Throwable)e, context, extContext)) {
                    throw new EvaluationException((Throwable)e);
                }
                context.responseComplete();
            }
            catch (IOException ioe) {
                logger.log((Throwable)ioe);
                throw new EvaluationException((Throwable)e);
            }
        }
        if (!context.getRenderResponse() && !context.getResponseComplete()) {
            super.processAction(actionEvent);
        }
    }

    private static boolean isExtendReturnType(BeanDesc bd, String methodName) {
        if (bd == null || methodName == null) {
            return false;
        }
        return bd.hasMethod(methodName) && bd.getMethod(methodName).getReturnType() == Class.class;
    }

    public NamingConvention getNamingConvention() {
        return this.nc;
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.nc = namingConvention;
    }

    protected void processAfterInvoke(FacesContext context, String fromAction, String outcome) {
        super.processAfterInvoke(context, fromAction, outcome);
        if (fromAction != null && fromAction.indexOf(".doFinish") > 0) {
            SubApplicationScope.removeContext((FacesContext)context);
        }
    }
}

