/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.application.NavigationHandlerImpl;
import org.seasar.teeda.core.portlet.FacesPortlet;
import org.seasar.teeda.core.util.NavigationHandlerUtil;
import org.seasar.teeda.core.util.PortletUtil;
import org.seasar.teeda.extension.html.HtmlSuffix;
import org.seasar.teeda.extension.html.PagePersistence;

public class HtmlNavigationHandler
extends NavigationHandlerImpl {
    private PagePersistence pagePersistence;
    private NamingConvention namingConvention;
    private ServletContext servletContext;
    private HtmlSuffix htmlSuffix;

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    public void setPagePersistence(PagePersistence pagePersistence) {
        this.pagePersistence = pagePersistence;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setHtmlSuffix(HtmlSuffix htmlSuffix) {
        this.htmlSuffix = htmlSuffix;
    }

    protected void redirect(FacesContext context, ExternalContext externalContext, String redirectPath, String newViewId) {
        this.pagePersistence.save(context, newViewId);
        NavigationHandlerUtil.assertNotAlreadyRedirect((FacesContext)context);
        super.redirect(context, externalContext, redirectPath, newViewId);
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        super.handleNavigation(context, fromAction, outcome);
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = context.getExternalContext().getRequestMap();
        if (context.getRenderResponse() && requestMap.get("TRANSITION_TEEDA_PREPARED") == null) {
            return;
        }
        if (context.getResponseComplete()) {
            return;
        }
        String viewId = context.getViewRoot().getViewId();
        String path = this.calcPathFromOutcome(context, viewId, outcome);
        if (path == null) {
            return;
        }
        ViewHandler viewHandler = context.getApplication().getViewHandler();
        if (!PortletUtil.isPortlet((FacesContext)context)) {
            String redirectPath = this.getRedirectActionPath(context, viewHandler, path);
            this.redirect(context, externalContext, redirectPath, path);
        } else {
            externalContext.getRequestMap().put(FacesPortlet.REDIRECT_TO_PORTLET, Boolean.TRUE);
            super.render(context, viewHandler, path);
        }
        requestMap.remove("TRANSITION_TEEDA_PREPARED");
    }

    protected String calcPathFromOutcome(FacesContext context, String viewId, String outcome) {
        if (outcome == null) {
            return null;
        }
        if (!this.namingConvention.isValidViewRootPath(viewId)) {
            return viewId;
        }
        int pos = viewId.lastIndexOf(47);
        int pos2 = viewId.lastIndexOf(46);
        String pathFirst = viewId.substring(0, pos + 1);
        String pathLast = viewId.substring(pos2);
        String[] names = StringUtil.split((String)outcome, (String)"_");
        String suffix = this.htmlSuffix.getSuffix(context);
        if (names.length == 1) {
            String path = pathFirst + outcome + suffix + pathLast;
            if (this.servletContext.getResourceAsStream(path) != null) {
                return path;
            }
            return pathFirst + outcome + pathLast;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < names.length; ++i) {
            buf.append(StringUtil.decapitalize((String)names[i]));
            if (i == names.length - 1) continue;
            buf.append("/");
        }
        pos = viewId.indexOf(47, 1);
        pathFirst = viewId.substring(0, pos + 1);
        String path = pathFirst + buf + suffix + pathLast;
        if (this.servletContext.getResourceAsStream(path) != null) {
            return path;
        }
        return pathFirst + buf + pathLast;
    }
}

