/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.html.DocumentNode;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.ElementNodeDecision;
import org.seasar.teeda.extension.html.HtmlNode;
import org.seasar.teeda.extension.html.impl.DocumentNodeImpl;
import org.seasar.teeda.extension.html.impl.ElementNodeImpl;
import org.seasar.teeda.extension.html.impl.HtmlNodeUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class HtmlNodeHandler
extends DefaultHandler {
    private Stack nodeStack = new Stack();
    private HtmlNode root;
    private Map dtdPaths = new HashMap();
    private List forceElementNodeTagName = new ArrayList();
    private Stack forceElementNodeStack = new Stack();
    private ElementNodeDecision[] decisions = new ElementNodeDecision[0];
    private static final String XHTML_DTD_RESOURCES_PATH = "org/seasar/teeda/extension/resource/xhtml1/";

    public HtmlNodeHandler() {
        this.initialize();
    }

    public HtmlNode getRoot() {
        return this.root;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        DocumentNodeImpl docNode = new DocumentNodeImpl();
        this.nodeStack.push(docNode);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
        Map props = HtmlNodeUtil.convertMap(attributes);
        if (this.root == null) {
            ElementNodeImpl n = new ElementNodeImpl(namespaceURI, localName, qName, props);
            this.root = n;
            DocumentNode docNode = (DocumentNode)this.nodeStack.peek();
            docNode.addChild(n);
            this.push(n);
        } else {
            ElementNode parent = this.peek();
            if (this.isElementNode(parent, namespaceURI, localName, qName, attributes)) {
                ElementNodeImpl elementNode = new ElementNodeImpl(namespaceURI, localName, qName, props);
                parent.addElement(elementNode);
                this.push(elementNode);
                if (this.forceElementNodeTagName.contains(qName)) {
                    this.forceElementNodeStack.push(elementNode);
                }
            } else {
                parent.addText(HtmlNodeUtil.getStartTagString(qName, props));
                parent.incrementChildTextSize();
            }
        }
    }

    private boolean isElementNode(ElementNode parent, String namespaceURI, String localName, String qName, Attributes attributes) {
        if (attributes.getValue("id") != null) {
            return true;
        }
        if (!StringUtil.isEmpty((String)namespaceURI) && !namespaceURI.equals("http://www.w3.org/1999/xhtml")) {
            return true;
        }
        if (!this.forceElementNodeStack.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.decisions.length; ++i) {
            ElementNodeDecision dec = this.decisions[i];
            if (!dec.isElementNode(parent, qName, attributes)) continue;
            return true;
        }
        return false;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        String dtdPath = null;
        if (publicId != null) {
            dtdPath = (String)this.dtdPaths.get(publicId);
        }
        if (dtdPath == null) {
            return null;
        }
        return new InputSource(ResourceUtil.getResourceAsStream((String)dtdPath));
    }

    protected ElementNode peek() {
        return (ElementNode)this.nodeStack.peek();
    }

    protected ElementNode pop() {
        return (ElementNode)this.nodeStack.pop();
    }

    protected void push(ElementNode node) {
        this.nodeStack.push(node);
    }

    public void characters(char[] buffer, int start, int length) {
        if (this.root == null) {
            DocumentNode docNode = (DocumentNode)this.nodeStack.peek();
            docNode.addText(new String(buffer, start, length));
            return;
        }
        String text = new String(buffer, start, length);
        ElementNode tagNode = this.peek();
        tagNode.addText(text);
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        ElementNode current = this.peek();
        if (current.getChildTextSize() == 0) {
            current.endElement();
            this.pop();
            if (!this.forceElementNodeStack.isEmpty() && current == this.forceElementNodeStack.peek()) {
                this.forceElementNodeStack.pop();
            }
        } else {
            current.addText(HtmlNodeUtil.getEndTagString(qName));
            current.decrementChildTextSize();
        }
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        DocumentNode docNode = (DocumentNode)this.nodeStack.pop();
        this.root = docNode;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public void warning(SAXParseException e) throws SAXException {
        System.err.println(e);
    }

    public void registerDtdPath(String publicId, String dtdPath) {
        this.dtdPaths.put(publicId, dtdPath);
    }

    protected void initialize() {
        this.initializeDtdPathForXhtml1();
    }

    protected void initializeDtdPathForXhtml1() {
        this.dtdPaths.put("-//W3C//DTD XHTML 1.0 Frameset//EN", "org/seasar/teeda/extension/resource/xhtml1/xhtml1-frameset.dtd");
        this.dtdPaths.put("-//W3C//DTD XHTML 1.0 Strict//EN", "org/seasar/teeda/extension/resource/xhtml1/xhtml1-strict.dtd");
        this.dtdPaths.put("-//W3C//DTD XHTML 1.0 Transitional//EN", "org/seasar/teeda/extension/resource/xhtml1/xhtml1-transitional.dtd");
        this.dtdPaths.put("-//W3C//ENTITIES Latin 1 for XHTML//EN", "org/seasar/teeda/extension/resource/xhtml1/xhtml-lat1.ent");
        this.dtdPaths.put("-//W3C//ENTITIES Symbols for XHTML//EN", "org/seasar/teeda/extension/resource/xhtml1/xhtml-symbol.ent");
        this.dtdPaths.put("-//W3C//ENTITIES Special for XHTML//EN", "org/seasar/teeda/extension/resource/xhtml1/xhtml-special.ent");
    }

    public void addForceElementNodeTagName(String tagName) {
        this.forceElementNodeTagName.add(tagName);
    }

    public void setElementNodeDecisions(ElementNodeDecision[] decisions) {
        this.decisions = decisions;
    }

    public void addElementNodeDecision(ElementNodeDecision decision) {
        this.decisions = (ElementNodeDecision[])ArrayUtil.add((Object[])this.decisions, (Object)decision);
    }
}

