/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.PageContextOutWriter;
import javax.faces.internal.PageContextUtil;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.servlet.S2ContainerServlet;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.teeda.core.application.ViewHandlerImpl;
import org.seasar.teeda.core.util.DIContainerUtil;
import org.seasar.teeda.core.util.ExternalContextUtil;
import org.seasar.teeda.core.util.PortletExternalContextUtil;
import org.seasar.teeda.core.util.PortletUtil;
import org.seasar.teeda.core.util.PostbackUtil;
import org.seasar.teeda.core.util.ServletExternalContextUtil;
import org.seasar.teeda.extension.component.RenderPreparableUtil;
import org.seasar.teeda.extension.exception.IllegalPageTransitionException;
import org.seasar.teeda.extension.exception.JspRuntimeException;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ActionDescCache;
import org.seasar.teeda.extension.html.HtmlSuffix;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.PageDescCache;
import org.seasar.teeda.extension.html.PagePersistence;
import org.seasar.teeda.extension.html.TagProcessor;
import org.seasar.teeda.extension.html.TagProcessorCache;
import org.seasar.teeda.extension.jsp.PageContextImpl;
import org.seasar.teeda.extension.util.PageTransitionUtil;

public class HtmlViewHandler
extends ViewHandlerImpl {
    private static final String INITIALIZE = "initialize";
    private static final String PRERENDER = "prerender";
    private TagProcessorCache tagProcessorCache;
    private PageDescCache pageDescCache;
    private ActionDescCache actionDescCache;
    private PagePersistence pagePersistence;
    private NamingConvention nc;
    private HtmlSuffix htmlSuffix;

    public void setTagProcessorCache(TagProcessorCache tagProcessorCache) {
        this.tagProcessorCache = tagProcessorCache;
    }

    public void setPageDescCache(PageDescCache pageDescCache) {
        this.pageDescCache = pageDescCache;
    }

    public void setActionDescCache(ActionDescCache actionDescCache) {
        this.actionDescCache = actionDescCache;
    }

    public void setPagePersistence(PagePersistence pagePersistence) {
        this.pagePersistence = pagePersistence;
    }

    public void setNamingConvention(NamingConvention nc) {
        this.nc = nc;
    }

    public void setHtmlSuffix(HtmlSuffix htmlSuffix) {
        this.htmlSuffix = htmlSuffix;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        this.htmlSuffix.setupSuffix(context, viewId);
        ExternalContext externalContext = context.getExternalContext();
        this.setUpRequestForExternalBinding(context, viewId);
        this.tagProcessorCache.updateTagProcessor(viewId);
        Map requestMap = externalContext.getRequestMap();
        if (!PostbackUtil.isPostback((Map)requestMap) && this.invoke(context, viewId, INITIALIZE) != null) {
            context.renderResponse();
        }
        return super.restoreView(context, viewId);
    }

    protected void setUpRequestForExternalBinding(FacesContext context, String viewId) {
        this.pagePersistence.restore(context, viewId);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        UIViewRoot viewRoot = super.createView(context, viewId);
        TagProcessor processor = this.tagProcessorCache.getTagProcessor(viewId);
        if (processor == null) {
            return viewRoot;
        }
        HttpServletRequest request = this.prepareRequest(context);
        HttpServletResponse response = this.prepareResponse(context);
        try {
            PageContext pageContext = this.createPageContext(request, response);
            PageContextUtil.setCurrentFacesContextAttribute((PageContext)pageContext, (FacesContext)context);
            PageContextUtil.setCurrentViewRootAttribute((PageContext)pageContext, (UIViewRoot)viewRoot);
            processor.composeComponentTree(context, pageContext, null);
        }
        catch (JspException e) {
            throw new JspRuntimeException(e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return viewRoot;
    }

    public void renderView(FacesContext context, UIViewRoot viewRoot) throws IOException {
        RenderPreparableUtil.encodePrepareForComponent(context, (UIComponent)viewRoot);
        ExternalContext externalContext = context.getExternalContext();
        String path = ExternalContextUtil.getViewId((ExternalContext)externalContext);
        this.renderView(context, path);
    }

    protected void renderView(FacesContext context, String path) throws IOException {
        HttpServletRequest request = this.prepareRequest(context);
        HttpServletResponse response = this.prepareResponse(context);
        this.setNoCacheToResponse(response);
        PageContext pageContext = this.createPageContext(request, response);
        this.setupResponseWriter(pageContext, null, request.getCharacterEncoding());
        if (this.invoke(context, path, PRERENDER) != null) {
            return;
        }
        TagProcessor tagProcessor = this.tagProcessorCache.getTagProcessor(path);
        try {
            tagProcessor.process(pageContext, null);
        }
        catch (JspException ex) {
            throw new JspRuntimeException(ex);
        }
        pageContext.getOut().flush();
    }

    protected String invoke(FacesContext context, String path, String methodName) {
        ActionDesc actionDesc;
        PageDesc pageDesc = this.pageDescCache.getPageDesc(path);
        Object target = null;
        if (pageDesc != null && pageDesc.hasMethod(methodName)) {
            target = DIContainerUtil.getComponent((Object)pageDesc.getPageName());
        }
        if (target == null && (actionDesc = this.actionDescCache.getActionDesc(path)) != null && actionDesc.hasMethod(methodName)) {
            target = DIContainerUtil.getComponent((Object)actionDesc.getActionName());
        }
        return this.navigate(context, path, target, methodName);
    }

    protected String navigate(FacesContext context, String path, Object target, String methodName) {
        String next = null;
        if (target != null) {
            Class<?> pageOrActionClass = target.getClass();
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(pageOrActionClass);
            Object ret = beanDesc.invoke(target, methodName, null);
            if (ret instanceof Class) {
                Class retClass = (Class)ret;
                String pageSuffix = this.nc.getPageSuffix();
                if (retClass != null && !retClass.getName().endsWith(pageSuffix)) {
                    throw new IllegalPageTransitionException(retClass);
                }
                next = PageTransitionUtil.getNextPageTransition(pageOrActionClass, retClass, this.nc);
            } else {
                next = (String)ret;
            }
            if (next != null) {
                if (context.getViewRoot() == null) {
                    UIViewRoot root = super.createView(context, path);
                    context.setViewRoot(root);
                }
                ExternalContext extContext = context.getExternalContext();
                Map requestMap = extContext.getRequestMap();
                requestMap.put("TRANSITION_TEEDA_PREPARED", Boolean.TRUE);
                this.navigateReally(context, next);
            }
        }
        return next;
    }

    protected void navigateReally(FacesContext context, String path) {
        Application app = context.getApplication();
        NavigationHandler nh = app.getNavigationHandler();
        nh.handleNavigation(context, null, path);
        if (context.getResponseComplete()) {
            return;
        }
        ViewHandler vh = app.getViewHandler();
        try {
            vh.renderView(context, context.getViewRoot());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    protected Servlet getServlet() {
        return S2ContainerServlet.getInstance();
    }

    protected ServletConfig getServletConfig() {
        return this.getServlet().getServletConfig();
    }

    protected ServletContext getServletContext() {
        return this.getServletConfig().getServletContext();
    }

    protected PageContext createPageContext(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PageContextImpl pageContext = new PageContextImpl();
        pageContext.initialize(this.getServlet(), (ServletRequest)request, (ServletResponse)response, null);
        return pageContext;
    }

    protected void setupResponseWriter(PageContext pageContext, String contentType, String encoding) {
        FacesContext context = FacesContext.getCurrentInstance();
        RenderKitFactory renderFactory = this.getRenderKitFactory();
        RenderKit renderKit = renderFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
        ResponseWriter writer = renderKit.createResponseWriter((Writer)new PageContextOutWriter(pageContext), contentType, encoding);
        context.setResponseWriter(writer);
    }

    protected RenderKitFactory getRenderKitFactory() {
        return (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
    }

    protected HttpServletRequest prepareRequest(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        if (!PortletUtil.isPortlet((FacesContext)context)) {
            return ServletExternalContextUtil.getRequest((ExternalContext)externalContext);
        }
        return PortletExternalContextUtil.wrapByHttpServletRequestWrapper((ExternalContext)externalContext);
    }

    protected HttpServletResponse prepareResponse(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        if (!PortletUtil.isPortlet((FacesContext)context)) {
            return ServletExternalContextUtil.getResponse((ExternalContext)externalContext);
        }
        return PortletExternalContextUtil.wrapByHttpServletResponseWrapper((ExternalContext)externalContext);
    }

    protected void setNoCacheToResponse(HttpServletResponse res) {
        SimpleDateFormat formatter = new SimpleDateFormat("E, dd MMM yyyy hh:mm:ss zzz", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String httpDate = formatter.format(new Date());
        res.setHeader("Expires", httpDate);
        res.setHeader("Pragma", "no-cache");
        res.setHeader("Cache-Control", "no-cache");
    }
}

