/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.teeda.extension.ExtensionConstants;
import org.seasar.teeda.extension.annotation.handler.ConverterAnnotationHandlerFactory;
import org.seasar.teeda.extension.annotation.handler.FacesMessageAnnotationHandlerFactory;
import org.seasar.teeda.extension.annotation.handler.ScopeAnnotationHandlerFactory;
import org.seasar.teeda.extension.annotation.handler.TakeOverDescAnnotationHandlerFactory;
import org.seasar.teeda.extension.annotation.handler.ValidatorAnnotationHandlerFactory;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.TakeOverDesc;
import org.seasar.teeda.extension.html.impl.ActionDescUtil;

public class PageDescImpl
implements PageDesc {
    private String pageName;
    private Set propertyNames = new HashSet();
    private Set itemsPropertyNames = new HashSet();
    private Set dynamicPropertyNames = new HashSet();
    private Set methodNames;
    private Map takeOverDescs;
    private Map propertyScopes;
    private File file;
    private long lastModified;

    public PageDescImpl(Class pageClass, String pageName) {
        this(pageClass, pageName, null);
    }

    public PageDescImpl(Class pageClass, String pageName, File file) {
        this.pageName = pageName;
        this.setup(pageClass);
        if (file != null) {
            this.file = file;
            this.lastModified = file.lastModified();
        }
    }

    public String getPageName() {
        return this.pageName;
    }

    protected void setup(Class pageClass) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)pageClass);
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (this.isItemsProperty(pd)) {
                this.itemsPropertyNames.add(pd.getPropertyName());
            }
            this.propertyNames.add(pd.getPropertyName());
            if (!this.isDynamicProperty(pd)) continue;
            this.dynamicPropertyNames.add(pd.getPropertyName());
        }
        this.methodNames = ActionDescUtil.getActionMethodNames(pageClass);
        String pageName = this.getPageName();
        this.handleAnnotations(pageName);
    }

    protected void handleAnnotations(String pageName) {
        ValidatorAnnotationHandlerFactory.getAnnotationHandler().registerValidators(pageName);
        ConverterAnnotationHandlerFactory.getAnnotationHandler().registerConverters(pageName);
        this.takeOverDescs = TakeOverDescAnnotationHandlerFactory.getAnnotationHandler().getTakeOverDescs(pageName);
        this.propertyScopes = ScopeAnnotationHandlerFactory.getAnnotationHandler().getPropertyScopes(pageName);
        FacesMessageAnnotationHandlerFactory.getAnnotationHandler().registerFacesMessages(pageName);
    }

    protected boolean isItemsProperty(PropertyDesc pd) {
        if (!pd.getPropertyName().endsWith("Items")) {
            return false;
        }
        Class clazz = pd.getPropertyType();
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz);
    }

    protected boolean isDynamicProperty(PropertyDesc pd) {
        return pd.hasReadMethod();
    }

    public boolean isRedirectScopeProperty(String name) {
        Integer scope = (Integer)this.propertyScopes.get(name);
        if (scope == null) {
            return false;
        }
        return ExtensionConstants.REDIRECT_SCOPE.equals(scope);
    }

    public boolean hasProperty(String name) {
        return this.propertyNames.contains(name);
    }

    public boolean hasItemsProperty(String name) {
        return this.itemsPropertyNames.contains(name);
    }

    public boolean hasDynamicProperty(String name) {
        return this.dynamicPropertyNames.contains(name);
    }

    public boolean hasMethod(String name) {
        return this.methodNames.contains(name);
    }

    public TakeOverDesc getTakeOverDesc(String methodName) {
        if (!this.hasTakeOverDesc(methodName)) {
            throw new IllegalArgumentException(methodName);
        }
        return (TakeOverDesc)this.takeOverDescs.get(methodName);
    }

    public boolean hasTakeOverDesc(String methodName) {
        return this.takeOverDescs.containsKey(methodName);
    }

    public boolean isModified() {
        if (this.file == null) {
            return false;
        }
        if (!this.file.exists()) {
            return true;
        }
        return this.file.lastModified() != this.lastModified;
    }
}

