/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesMessageUtil;
import javax.faces.internal.UICommandUtil;
import javax.faces.internal.scope.RedirectScope;
import javax.faces.internal.scope.SubApplicationScope;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.log.Logger;
import org.seasar.framework.message.MessageFormatter;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.util.DIContainerUtil;
import org.seasar.teeda.core.util.ServletExternalContextUtil;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ActionDescCache;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.PageDescCache;
import org.seasar.teeda.extension.html.PagePersistence;
import org.seasar.teeda.extension.html.TakeOverDesc;
import org.seasar.teeda.extension.html.impl.TakeOverTypeDescFactory;
import org.seasar.teeda.extension.util.PagePersistenceUtil;
import org.seasar.teeda.extension.util.TeedaExtensionErrorPageManagerImpl;

public class SessionPagePersistence
implements PagePersistence {
    private static final long serialVersionUID = 1L;
    private PageDescCache pageDescCache;
    private ActionDescCache actionDescCache;
    private NamingConvention namingConvention;
    private static final String ERROR_MESSAGE_PERSISTE_KEY = "teeda.FacesMessages";
    private static final String SUB_APPLICATION_SCOPE_KEY = SessionPagePersistence.class.getName();
    private static final String REDIRECT_SCOPE_KEY = SessionPagePersistence.class.getName();
    private static final Logger logger = Logger.getLogger((Class)SessionPagePersistence.class);
    static /* synthetic */ Class class$java$util$Collection;

    public void save(FacesContext context, String viewId) {
        if (context == null) {
            return;
        }
        UIViewRoot viewRoot = context.getViewRoot();
        String previousViewId = viewRoot != null ? viewRoot.getViewId() : null;
        Map subappValues = this.getOrCreateSubApplicationScopeValues(context);
        Map redirectValues = this.getOrCreateRedirectScopeValues(context);
        this.savePageValues(subappValues, redirectValues, context, viewId, previousViewId);
    }

    public void restore(FacesContext context, String viewId) {
        Map redirectValues;
        if (context == null) {
            return;
        }
        ExternalContext extCtx = context.getExternalContext();
        Map requestMap = extCtx.getRequestMap();
        if (SessionPagePersistence.isOutputlinkTransition(context, extCtx)) {
            return;
        }
        Map subappValues = this.getSubApplicationScopeValues(context);
        if (subappValues != null) {
            this.restoreValues(subappValues, requestMap);
        }
        if ((redirectValues = this.getRedirectScopeValues(context)) != null) {
            this.restoreValues(redirectValues, requestMap);
        }
        TeedaExtensionErrorPageManagerImpl.restoreMessage(context);
    }

    protected static boolean isOutputlinkTransition(FacesContext context, ExternalContext externalContext) {
        return !RedirectScope.isRedirecting((FacesContext)context) && !ServletExternalContextUtil.isPost((ExternalContext)externalContext);
    }

    protected void saveFacesMessage(FacesContext from, Map to) {
        FacesMessage[] messages = FacesMessageUtil.getAllMessages((FacesContext)from);
        to.put(ERROR_MESSAGE_PERSISTE_KEY, messages);
    }

    protected void restoreFacesMessages(Map from, FacesContext to) {
        FacesMessage[] messages = (FacesMessage[])from.remove(ERROR_MESSAGE_PERSISTE_KEY);
        if (messages == null) {
            return;
        }
        for (int i = 0; i < messages.length; ++i) {
            to.addMessage(null, messages[i]);
        }
    }

    protected void savePageValues(Map subappValues, Map redirectValues, FacesContext context, String viewId, String previousViewId) {
        PageDesc pageDesc;
        PageDesc pageDesc2 = pageDesc = previousViewId != null ? this.pageDescCache.getPageDesc(previousViewId) : null;
        if (pageDesc == null) {
            return;
        }
        Object page = DIContainerUtil.getComponent((Object)pageDesc.getPageName());
        this.savePageValues(subappValues, redirectValues, context, page, viewId, previousViewId, pageDesc);
    }

    protected void savePageValues(Map subappValues, Map redirectValues, FacesContext context, Object page, String viewId, String previousViewId, PageDesc pageDesc) {
        Class<?> pageClass = page.getClass();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(pageClass);
        Map nextPageProperties = this.getNextPageProperties(viewId);
        if (nextPageProperties.isEmpty()) {
            return;
        }
        this.savePageValues(subappValues, redirectValues, context, beanDesc, previousViewId, pageDesc, page, nextPageProperties);
    }

    protected Map getNextPageProperties(String viewId) {
        HashMap<String, Class> map = new HashMap<String, Class>();
        String nextPageName = this.namingConvention.fromPathToPageName(viewId);
        Class nextPageClass = this.namingConvention.fromComponentNameToClass(nextPageName);
        if (nextPageClass == null) {
            return map;
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)nextPageClass);
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            String propertyName;
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (!pd.hasWriteMethod() || "postback".equals(propertyName = pd.getPropertyName()) || "previousViewId".equals(propertyName)) continue;
            map.put(propertyName, pd.getPropertyType());
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void savePageValues(Map subappValues, Map redirectValues, FacesContext context, BeanDesc beanDesc, String previousViewId, PageDesc pageDesc, Object page, Map nextPageProperties) {
        String methodName = UICommandUtil.getSubmittedCommand((FacesContext)context);
        try {
            ActionDesc actionDesc = this.actionDescCache.getActionDesc(previousViewId);
            if (methodName != null && actionDesc != null && actionDesc.hasTakeOverDesc(methodName)) {
                this.savePageValues(subappValues, redirectValues, context, beanDesc, actionDesc.getTakeOverDesc(methodName), page, nextPageProperties, pageDesc);
            } else if (methodName != null && pageDesc != null && pageDesc.hasTakeOverDesc(methodName)) {
                this.savePageValues(subappValues, redirectValues, context, beanDesc, pageDesc.getTakeOverDesc(methodName), page, nextPageProperties, pageDesc);
            } else {
                this.saveDefaultPageValues(subappValues, redirectValues, context, beanDesc, page, nextPageProperties, pageDesc);
            }
            Object var12_11 = null;
            if (methodName == null || !methodName.startsWith("doFinish")) return;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (methodName == null || !methodName.startsWith("doFinish")) throw throwable;
            SubApplicationScope.removeContext((FacesContext)context);
            throw throwable;
        }
        SubApplicationScope.removeContext((FacesContext)context);
    }

    protected void savePageValues(Map subappValues, Map redirectValues, FacesContext context, BeanDesc beanDesc, TakeOverDesc takeOverDesc, Object page, Map nextPageProperties, PageDesc pageDesc) {
        AssertionUtil.assertNotNull((String)"takeOverDesc", (Object)takeOverDesc);
        String[] properties = takeOverDesc.getProperties();
        if (SessionPagePersistence.isTakeOverNever(takeOverDesc)) {
            this.refreshSubApplicationScopeMap(context, subappValues);
        } else if (SessionPagePersistence.isTakeOverInclude(takeOverDesc)) {
            subappValues = this.refreshSubApplicationScopeMap(context, subappValues);
            this.saveIncludePageValues(subappValues, redirectValues, context, beanDesc, page, properties, nextPageProperties, pageDesc);
        } else if (SessionPagePersistence.isTakeOverExclude(takeOverDesc)) {
            subappValues = this.refreshSubApplicationScopeMap(context, subappValues);
            this.saveExcludePageValues(subappValues, context, beanDesc, page, properties, nextPageProperties);
        } else {
            this.saveDefaultPageValues(subappValues, redirectValues, context, beanDesc, page, nextPageProperties, pageDesc);
        }
    }

    private static boolean isTakeOverNever(TakeOverDesc desc) {
        return TakeOverTypeDescFactory.NEVER.equals(desc.getTakeOverTypeDesc());
    }

    private static boolean isTakeOverInclude(TakeOverDesc desc) {
        return TakeOverTypeDescFactory.INCLUDE.equals(desc.getTakeOverTypeDesc()) && desc.getProperties().length != 0;
    }

    private static boolean isTakeOverExclude(TakeOverDesc desc) {
        return TakeOverTypeDescFactory.EXCLUDE.equals(desc.getTakeOverTypeDesc()) && desc.getProperties().length != 0;
    }

    protected Map refreshSubApplicationScopeMap(FacesContext context, Map subappValues) {
        Map scopeContext;
        Map subAppScopeMap = this.getSubApplicationScopeValues(context);
        if (subAppScopeMap != null && (scopeContext = SubApplicationScope.getContext((FacesContext)context)) != null) {
            scopeContext.remove(SUB_APPLICATION_SCOPE_KEY);
            subappValues = this.getOrCreateSubApplicationScopeValues(context);
        }
        return subappValues;
    }

    protected void saveIncludePageValues(Map subappValues, Map redirectValues, FacesContext context, BeanDesc beanDesc, Object page, String[] properties, Map nextPageProperties, PageDesc pageDesc) {
        for (int i = 0; i < properties.length; ++i) {
            String propertyName = properties[i];
            PropertyDesc pd = beanDesc.getPropertyDesc(propertyName);
            if (!pd.hasReadMethod() || !nextPageProperties.containsKey(pd.getPropertyName())) continue;
            if (pageDesc.isRedirectScopeProperty(propertyName)) {
                this.putValue(redirectValues, page, pd);
                continue;
            }
            this.putValue(subappValues, page, pd);
        }
    }

    protected void saveExcludePageValues(Map subappValues, FacesContext context, BeanDesc beanDesc, Object page, String[] properties, Map nextPageProperties) {
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (!pd.hasReadMethod() || !nextPageProperties.containsKey(pd.getPropertyName()) || ArrayUtil.contains((Object[])properties, (Object)pd.getPropertyName())) continue;
            this.putValue(subappValues, page, pd);
        }
    }

    protected void saveDefaultPageValues(Map subappValues, Map redirectValues, FacesContext context, BeanDesc beanDesc, Object page, Map nextPageProperties, PageDesc pageDesc) {
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            Class thisPageType;
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            String propertyName = pd.getPropertyName();
            if (!pd.hasReadMethod() || !nextPageProperties.containsKey(propertyName) || !(thisPageType = pd.getPropertyType()).isArray() && !(class$java$util$Collection == null ? SessionPagePersistence.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(thisPageType) && !PagePersistenceUtil.isPersistenceType(thisPageType)) continue;
            Class nextPageType = (Class)nextPageProperties.get(propertyName);
            if (nextPageType != thisPageType) {
                Object[] args = new Object[]{propertyName, thisPageType.getName(), nextPageType.getName()};
                String message = MessageFormatter.getMessage((String)"WTDA0201", (Object[])args);
                logger.debug((Object)message);
            }
            if (pageDesc.isRedirectScopeProperty(propertyName)) {
                this.putValue(redirectValues, page, pd);
                continue;
            }
            this.putValue(subappValues, page, pd);
        }
    }

    protected void putValue(Map map, Object page, PropertyDesc pd) {
        Object value = pd.getValue(page);
        map.put(pd.getPropertyName(), value);
    }

    protected Map getSubApplicationScopeValues(FacesContext context) {
        Map scopeContext = SubApplicationScope.getContext((FacesContext)context);
        if (scopeContext == null) {
            return null;
        }
        return (Map)scopeContext.get(SUB_APPLICATION_SCOPE_KEY);
    }

    protected Map getOrCreateSubApplicationScopeValues(FacesContext context) {
        Map scopeContext = SubApplicationScope.getOrCreateContext((FacesContext)context);
        HashMap values = (HashMap)scopeContext.get(SUB_APPLICATION_SCOPE_KEY);
        if (values == null) {
            values = new HashMap();
            scopeContext.put(SUB_APPLICATION_SCOPE_KEY, values);
        }
        return values;
    }

    protected Map getRedirectScopeValues(FacesContext context) {
        Map scopeContext = RedirectScope.getContext((FacesContext)context);
        if (scopeContext == null) {
            return null;
        }
        return (Map)scopeContext.get(REDIRECT_SCOPE_KEY);
    }

    protected Map getOrCreateRedirectScopeValues(FacesContext context) {
        Map scopeContext = RedirectScope.getOrCreateContext((FacesContext)context);
        HashMap values = (HashMap)scopeContext.get(REDIRECT_SCOPE_KEY);
        if (values == null) {
            values = new HashMap();
            scopeContext.put(REDIRECT_SCOPE_KEY, values);
        }
        return values;
    }

    protected void restoreValues(Map from, Map to) {
        Iterator itr = from.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Object rebuildValue = HotdeployUtil.rebuildValue(value);
            if (rebuildValue instanceof ArrayList) {
                ArrayList list = (ArrayList)rebuildValue;
                rebuildValue = list.clone();
            }
            to.put(key, rebuildValue);
        }
    }

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    public void setPageDescCache(PageDescCache pageDescCache) {
        this.pageDescCache = pageDescCache;
    }

    public ActionDescCache getActionDescCache() {
        return this.actionDescCache;
    }

    public void setActionDescCache(ActionDescCache actionDescCache) {
        this.actionDescCache = actionDescCache;
    }
}

