/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputHidden;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.extension.component.TCondition;

public class TConditionRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.Condition";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.Condition";
    private final IgnoreAttribute attribute = new IgnoreAttribute();

    public TConditionRenderer() {
        this.attribute.addAttributeName("id");
        this.attribute.addAttributeName("submitted");
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        this.decodeTCondition(context, (TCondition)component);
    }

    protected void decodeTCondition(FacesContext context, TCondition condition) {
        Object submitted = null;
        Iterator itr = condition.getChildren().iterator();
        while (itr.hasNext()) {
            UIComponent c = (UIComponent)itr.next();
            if (!(c instanceof HtmlInputHidden)) continue;
            HtmlInputHidden hidden = (HtmlInputHidden)c;
            String hiddenId = c.getId();
            if (!hiddenId.equals(condition.getId() + "TeedaHidden")) continue;
            hidden.decode(context);
            submitted = hidden.getSubmittedValue();
            break;
        }
        if ("true".equals(submitted)) {
            condition.setSubmitted(true);
        } else {
            condition.setSubmitted(false);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
        boolean rendered = component.isRendered();
        Iterator itr = component.getChildren().iterator();
        while (itr.hasNext()) {
            String hiddenId;
            UIComponent c = (UIComponent)itr.next();
            if (!(c instanceof HtmlInputHidden) || !(hiddenId = c.getId()).equals(component.getId() + "TeedaHidden")) continue;
            ((HtmlInputHidden)c).setValue((Object)new Boolean(rendered));
            break;
        }
        if (!rendered) {
            return;
        }
        TCondition condition = (TCondition)component;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)condition);
        RendererUtil.renderIdAttributeIfNecessary((ResponseWriter)writer, (UIComponent)component, (String)this.getIdForRender(context, (UIComponent)condition));
        this.renderRemainAttributes((UIComponent)condition, writer, this.attribute);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("div");
    }

    public boolean getRendersChildren() {
        return true;
    }
}

