/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import java.util.Locale;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import org.seasar.framework.util.DateConversionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.extension.component.html.THtmlInputDateText;
import org.seasar.teeda.extension.component.html.THtmlInputText;
import org.seasar.teeda.extension.render.html.AbstractInputExtendTextRenderer;

public class THtmlInputDateTextRenderer
extends AbstractInputExtendTextRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.HtmlInputDateText";
    private static final String DEFAULT_THRESHOLD = "71";
    private static final String JS_NAMESPACE_PREFIX = "Teeda.THtmlInputDateText.";

    protected void doEncodeEndCustomize(FacesContext context, THtmlInputText htmlInputText) throws IOException {
        String threshold;
        THtmlInputDateTextRenderer.assertHtmlInputDateText(htmlInputText);
        THtmlInputDateText htmlInputDateText = (THtmlInputDateText)htmlInputText;
        ResponseWriter writer = context.getResponseWriter();
        String pattern = this.getPattern(context, htmlInputDateText);
        String length = htmlInputDateText.getLength();
        if (length == null) {
            length = THtmlInputDateTextRenderer.calculateLength(pattern);
        }
        if ((threshold = htmlInputDateText.getThreshold()) == null) {
            threshold = DEFAULT_THRESHOLD;
        }
        String delim = DateConversionUtil.findDelimiterFromPattern((String)pattern);
        InputDateValueHolder holder = new InputDateValueHolder(pattern, length, threshold, delim);
        this.renderOnfocus(htmlInputDateText, writer, holder);
        this.renderOnblur(htmlInputDateText, writer, holder);
        this.renderOnkeydown(htmlInputDateText, writer, holder);
        this.renderOnkeypress(htmlInputDateText, writer, holder);
        this.renderOnkeyup(htmlInputDateText, writer, holder);
        this.renderStyle(htmlInputDateText, writer);
        this.renderStyleClass(context, htmlInputDateText, writer);
    }

    protected static String calculateLength(String pattern) {
        String p = DateConversionUtil.removeDelimiter((String)pattern);
        if (p.indexOf("yyyy") >= 0) {
            p = StringUtil.replace((String)p, (String)"yyyy", (String)"yy");
        }
        return String.valueOf(p.length());
    }

    protected static void assertHtmlInputDateText(HtmlInputText htmlInputText) {
        if (!(htmlInputText instanceof THtmlInputDateText)) {
            throw new IllegalStateException();
        }
    }

    protected String getPattern(FacesContext context, THtmlInputDateText htmlInputDateText) {
        String pattern = htmlInputDateText.getPattern();
        Locale locale = context.getViewRoot().getLocale();
        if (pattern == null) {
            pattern = DateConversionUtil.getY4Pattern((Locale)locale);
        }
        return pattern;
    }

    protected void renderStyle(THtmlInputDateText htmlInputDateText, ResponseWriter writer) throws IOException {
        String style = this.createStyleAttribute(htmlInputDateText);
        if (StringUtil.isNotBlank((String)style)) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"style", (Object)style);
        }
    }

    protected String createStyleAttribute(THtmlInputDateText htmlInputDateText) {
        String style = THtmlInputDateTextRenderer.appendSemiColonIfNeed(htmlInputDateText.getStyle());
        String s = "ime-mode:disabled;";
        if (StringUtil.contains((String)style, (String)"ime-mode:disabled;")) {
            return style;
        }
        return style + "ime-mode:disabled;";
    }

    protected void renderOnfocus(THtmlInputDateText htmlInputDateText, ResponseWriter writer, InputDateValueHolder holder) throws IOException {
        String target;
        String delim = holder.getDelim();
        String length = holder.getLength();
        String onfocus = THtmlInputDateTextRenderer.appendSemiColonIfNeed(htmlInputDateText.getOnfocus());
        if (!onfocus.endsWith(target = "Teeda.THtmlInputDateText.removeDelimeter(this, '" + delim + "', " + length + ");")) {
            onfocus = onfocus + target;
        }
        if (StringUtil.isNotBlank((String)onfocus)) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"onfocus", (Object)onfocus);
        }
    }

    protected void renderOnblur(THtmlInputDateText htmlInputDateText, ResponseWriter writer, InputDateValueHolder holder) throws IOException {
        String onblur = this.createOnblurAttribute(htmlInputDateText, holder);
        if (StringUtil.isNotBlank((String)onblur)) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"onblur", (Object)onblur);
        }
    }

    protected String createOnblurAttribute(THtmlInputDateText htmlInputDateText, InputDateValueHolder holder) {
        String s;
        String pattern = holder.getPattern();
        String length = holder.getLength();
        String threshold = holder.getThreshold();
        String delim = holder.getDelim();
        String onblur = THtmlInputDateTextRenderer.appendSemiColonIfNeed(htmlInputDateText.getOnblur());
        if (StringUtil.contains((String)onblur, (String)(s = "Teeda.THtmlInputDateText.convertByKey(this);Teeda.THtmlInputDateText.addDelimeter(this, '" + pattern + "', " + length + ", " + threshold + ", '" + delim + "');"))) {
            return onblur;
        }
        return onblur + s;
    }

    protected void renderOnkeydown(THtmlInputDateText htmlInputDateText, ResponseWriter writer, InputDateValueHolder holder) throws IOException {
        String onkeydown = THtmlInputDateTextRenderer.appendSemiColonIfNeed(htmlInputDateText.getOnkeydown());
        this.renderKeycheckEvent(writer, "onkeydown", onkeydown, holder);
    }

    protected void renderOnkeypress(THtmlInputDateText htmlInputDateText, ResponseWriter writer, InputDateValueHolder holder) throws IOException {
        String onkeypress = THtmlInputDateTextRenderer.appendSemiColonIfNeed(htmlInputDateText.getOnkeypress());
        this.renderKeycheckEvent(writer, "onkeypress", onkeypress, holder);
    }

    protected void renderOnkeyup(THtmlInputDateText htmlInputDateText, ResponseWriter writer, InputDateValueHolder holder) throws IOException {
        String onkeyup = THtmlInputDateTextRenderer.appendSemiColonIfNeed(htmlInputDateText.getOnkeyup());
        this.renderKeycheckEvent(writer, "onkeyup", onkeyup, holder);
    }

    private void renderKeycheckEvent(ResponseWriter writer, String attributeName, String target, InputDateValueHolder holder) throws IOException {
        String pattern = holder.getPattern();
        String length = holder.getLength();
        String threshold = holder.getThreshold();
        String delim = holder.getDelim();
        String script = "return Teeda.THtmlInputDateText.keycheckForNumber(event, this, '" + pattern + "', " + length + ", " + threshold + ", '" + delim + "');";
        if (!target.endsWith(script)) {
            target = target + script;
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)attributeName, (Object)target);
        }
    }

    protected IgnoreAttribute buildIgnoreComponent() {
        IgnoreAttribute ignore = super.buildIgnoreComponent();
        ignore.addAttributeName("style");
        ignore.addAttributeName("styleClass");
        ignore.addAttributeName("onfocus");
        ignore.addAttributeName("onblur");
        ignore.addAttributeName("onkeydown");
        ignore.addAttributeName("onkeypress");
        ignore.addAttributeName("onkeyup");
        ignore.addAttributeName("disabled");
        ignore.addAttributeName("pattern");
        ignore.addAttributeName("length");
        ignore.addAttributeName("threshold");
        return ignore;
    }

    protected String getScriptKey() {
        return THtmlInputDateText.class.getName();
    }

    protected static class InputDateValueHolder {
        private String pattern;
        private String length;
        private String threshold;
        private String delim;

        public InputDateValueHolder(String pattern, String length, String threshold, String delim) {
            this.pattern = pattern;
            this.length = length;
            this.threshold = threshold;
            this.delim = delim;
        }

        public String getDelim() {
            return this.delim;
        }

        public String getLength() {
            return this.length;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getThreshold() {
            return this.threshold;
        }
    }
}

