/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.DateTimeConverter;
import org.seasar.teeda.core.context.html.HtmlResponseWriter;
import org.seasar.teeda.core.render.html.HtmlInputTextRenderer;
import org.seasar.teeda.extension.component.html.THtmlPopupCalendar;
import org.seasar.teeda.extension.render.RenderPreparableRenderer;
import org.seasar.teeda.extension.render.html.THtmlCalendarRendererUtil;
import org.seasar.teeda.extension.util.DateFormatSymbolsUtil;
import org.seasar.teeda.extension.util.VirtualResource;

public class THtmlPopupCalendarRenderer
extends HtmlInputTextRenderer
implements RenderPreparableRenderer {
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.HtmlPopupCalendar";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.HtmlPopupCalendar";
    private static final String JAVASCRIPT_ENCODED = "org.seasar.teeda.extension.popupcalendar.JAVASCRIPT_ENCODED";
    private static final String RESOURCE_ROOT = "org/seasar/teeda/extension/render/html/popupcalendar/";

    public void encodePrepare(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlPopupCalendarPrepare(context, (THtmlPopupCalendar)component);
    }

    protected void encodeHtmlPopupCalendarPrepare(FacesContext context, THtmlPopupCalendar htmlCalendar) throws IOException {
        if (context.getExternalContext().getRequestMap().containsKey(JAVASCRIPT_ENCODED)) {
            return;
        }
        Locale currentLocale = context.getViewRoot().getLocale();
        Calendar timeKeeper = Calendar.getInstance(currentLocale);
        DateFormatSymbols symbols = new DateFormatSymbols(currentLocale);
        String[] months = DateFormatSymbolsUtil.getMonths(symbols);
        int firstDayOfWeek = timeKeeper.getFirstDayOfWeek();
        VirtualResource.addCssResource(context, "org/seasar/teeda/extension/render/html/popupcalendar/css/theme.css");
        VirtualResource.addJsResource(context, "org/seasar/teeda/extension/render/html/popupcalendar/js/popcalendar_init.js");
        VirtualResource.addJsResource(context, "org/seasar/teeda/extension/render/html/popupcalendar/js/popcalendar.js");
        StringBuffer script = new StringBuffer();
        THtmlPopupCalendarRenderer.appendImageDirectory(context, script);
        script.append("\n");
        script.append(THtmlPopupCalendarRenderer.getLocalizedLanguageScript(symbols, months, firstDayOfWeek, htmlCalendar));
        script.append("\n");
        script.append("loadPopupScript();");
        VirtualResource.addInlineJsResource(context, JAVASCRIPT_ENCODED, script.toString());
        context.getExternalContext().getRequestMap().put(JAVASCRIPT_ENCODED, Boolean.TRUE);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        THtmlPopupCalendar htmlCalendar = (THtmlPopupCalendar)component;
        Locale currentLocale = context.getViewRoot().getLocale();
        Date value = (Date)htmlCalendar.getValue();
        Calendar timeKeeper = Calendar.getInstance(currentLocale);
        timeKeeper.setTime(value != null ? value : new Date());
        DateTimeConverter converter = THtmlCalendarRendererUtil.getConverter(context, (UIOutput)((UIInput)component));
        if (!htmlCalendar.isDisabled()) {
            ResponseWriter writer = context.getResponseWriter();
            String dateFormat = converter.getPattern();
            writer.startElement("script", component);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeText((Object)this.getScriptBtn(context, (UIComponent)htmlCalendar, dateFormat), null);
            writer.endElement("script");
        }
    }

    private static void appendImageDirectory(FacesContext context, StringBuffer script) {
        script.append("jscalendarSetImageDirectory('");
        script.append(VirtualResource.convertVirtualPath(context, "org/seasar/teeda/extension/render/html/popupcalendar/images/"));
        script.append("');");
    }

    /*
     * WARNING - void declaration
     */
    private static String getLocalizedLanguageScript(DateFormatSymbols symbols, String[] months, int firstDayOfWeek, THtmlPopupCalendar htmlCalendar) {
        void var5_5;
        String[] weekDays;
        int realFirstDayOfWeek = firstDayOfWeek - 1;
        if (realFirstDayOfWeek == 0) {
            weekDays = DateFormatSymbolsUtil.getWeekdaysStartingWithSunday(symbols);
        } else if (realFirstDayOfWeek == 1) {
            weekDays = DateFormatSymbolsUtil.getWeekdays(symbols);
        } else {
            throw new IllegalStateException("Week may only start with sunday or monday.");
        }
        StringBuffer script = new StringBuffer();
        THtmlPopupCalendarRenderer.defineStringArray(script, "jscalendarMonthName", months);
        THtmlPopupCalendarRenderer.defineStringArray(script, "jscalendarMonthName2", months);
        THtmlPopupCalendarRenderer.defineStringArray(script, "jscalendarDayName", (String[])var5_5);
        THtmlPopupCalendarRenderer.setIntegerVariable(script, "jscalendarStartAt", realFirstDayOfWeek);
        if (htmlCalendar.getPopupGotoString() != null) {
            THtmlPopupCalendarRenderer.setStringVariable(script, "jscalendarGotoString", htmlCalendar.getPopupGotoString());
        }
        if (htmlCalendar.getPopupTodayString() != null) {
            THtmlPopupCalendarRenderer.setStringVariable(script, "jscalendarTodayString", htmlCalendar.getPopupTodayString());
        }
        if (htmlCalendar.getPopupWeekString() != null) {
            THtmlPopupCalendarRenderer.setStringVariable(script, "jscalendarWeekString", htmlCalendar.getPopupWeekString());
        }
        if (htmlCalendar.getPopupScrollLeftMessage() != null) {
            THtmlPopupCalendarRenderer.setStringVariable(script, "jscalendarScrollLeftMessage", htmlCalendar.getPopupScrollLeftMessage());
        }
        if (htmlCalendar.getPopupScrollRightMessage() != null) {
            THtmlPopupCalendarRenderer.setStringVariable(script, "jscalendarScrollRightMessage", htmlCalendar.getPopupScrollRightMessage());
        }
        if (htmlCalendar.getPopupSelectMonthMessage() != null) {
            THtmlPopupCalendarRenderer.setStringVariable(script, "jscalendarSelectMonthMessage", htmlCalendar.getPopupSelectMonthMessage());
        }
        if (htmlCalendar.getPopupSelectYearMessage() != null) {
            THtmlPopupCalendarRenderer.setStringVariable(script, "jscalendarSelectYearMessage", htmlCalendar.getPopupSelectYearMessage());
        }
        if (htmlCalendar.getPopupSelectDateMessage() != null) {
            THtmlPopupCalendarRenderer.setStringVariable(script, "jscalendarSelectDateMessage", htmlCalendar.getPopupSelectDateMessage());
        }
        return script.toString();
    }

    private static void setIntegerVariable(StringBuffer script, String name, int value) {
        script.append(name);
        script.append(" = ");
        script.append(value);
        script.append(";\n");
    }

    private static void setStringVariable(StringBuffer script, String name, String value) {
        script.append(name);
        script.append(" = \"");
        script.append(value);
        script.append("\";\n");
    }

    private static void defineStringArray(StringBuffer script, String arrayName, String[] array) {
        script.append(arrayName);
        script.append(" = new Array(");
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                script.append(",");
            }
            script.append("\"");
            script.append(array[i]);
            script.append("\"");
        }
        script.append(");");
    }

    private String getScriptBtn(FacesContext context, UIComponent component, String dateFormat) throws IOException {
        HtmlResponseWriter writer = new HtmlResponseWriter();
        writer.setWriter((Writer)new StringWriter());
        writer.write("document.write('");
        writer.startElement("img", component);
        writer.writeAttribute("src", (Object)VirtualResource.convertVirtualPath(context, "org/seasar/teeda/extension/render/html/popupcalendar/images/calendar.gif"), null);
        writer.writeAttribute("style", (Object)"vertical-align:bottom;", null);
        this.writeOnclickJsCalendarFunctionCall((ResponseWriter)writer, context, component, dateFormat);
        writer.endElement("img");
        writer.write("');\n");
        return writer.toString();
    }

    private void writeOnclickJsCalendarFunctionCall(ResponseWriter writer, FacesContext facesContext, UIComponent uiComponent, String dateFormat) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        String jsCalendarFunctionCall = "jscalendarPopUpCalendar(this,document.getElementById(\\'" + clientId + "\\'),\\'" + dateFormat + "\\')";
        writer.writeAttribute("onclick", (Object)jsCalendarFunctionCall, null);
    }
}

