/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.component.html.HtmlInputHidden;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.extension.ExtensionConstants;
import org.seasar.teeda.extension.component.ScriptEnhanceUIViewRoot;
import org.seasar.teeda.extension.component.TreeModel;
import org.seasar.teeda.extension.component.TreeNode;
import org.seasar.teeda.extension.component.UITreeData;
import org.seasar.teeda.extension.component.html.THtmlTree;
import org.seasar.teeda.extension.util.JavaScriptContext;
import org.seasar.teeda.extension.util.TreeNavigationImageLocator;

public class THtmlTreeRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.Tree";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.THtmlTree";
    protected static final String TOGGLE_DIV = "teeda.extension.tree.TOGGLE_SPAN";
    protected static final String ROOT_NODE_ID = "0";
    private static final String NODE_STATE_EXPANDED = "x";
    private static final String NODE_STATE_CLOSED = "c";
    private static final String IMAGE_PREFIX = "t2";
    private static final String NAMESPACE = "Teeda.THtmlTree.";
    private static final String TOGGLE_VALUE_SUFFIX = ExtensionConstants.NAME_SEPARATOR + "treeExpanded";
    private TreeNavigationImageLocator imageLocator;
    public static final String imageLocator_BINDING = "bindingType=may";

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        this.decodeTHtmlTree(context, (THtmlTree)component);
    }

    protected void decodeTHtmlTree(FacesContext context, THtmlTree tree) {
        if (tree.getDataModel() == null) {
            return;
        }
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        this.decodeTreeNodeExpansion(tree, paramMap);
        this.decodeTreeValue(context, tree, paramMap);
    }

    protected void decodeTreeNodeExpansion(THtmlTree tree, Map paramMap) {
        TreeModel model = tree.getDataModel();
        String prefix = TOGGLE_DIV + ExtensionConstants.NAME_SEPARATOR + tree.getId() + ExtensionConstants.NAME_SEPARATOR;
        Iterator itr = paramMap.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (!key.startsWith(prefix) || !key.endsWith(TOGGLE_VALUE_SUFFIX)) continue;
            String nodeId = StringUtil.replace((String)key, (String)prefix, (String)"");
            nodeId = StringUtil.replace((String)nodeId, (String)TOGGLE_VALUE_SUFFIX, (String)"");
            String value = (String)paramMap.get(key);
            if ("true".equalsIgnoreCase(value)) {
                model.toggleExpanded(nodeId);
                continue;
            }
            model.collapseExpanded(nodeId);
        }
    }

    protected void decodeTreeValue(FacesContext context, THtmlTree tree, Map paramMap) {
        TreeModel model = tree.getDataModel();
        String clientId = tree.getClientId(context);
        String targetPrefix = clientId + ExtensionConstants.NAME_SEPARATOR;
        String[] candidates = this.getTreeValueDecodeCandidate(targetPrefix, paramMap);
        for (int i = 0; i < candidates.length; ++i) {
            String key = candidates[i];
            Object value = paramMap.get(key);
            String s = key.substring(targetPrefix.length(), key.lastIndexOf(ExtensionConstants.NAME_SEPARATOR));
            TreeNode node = model.getNodeById(s);
            node.setValue(value);
        }
    }

    protected String[] getTreeValueDecodeCandidate(String targetPrefix, Map paramMap) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator itr = paramMap.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (!key.startsWith(targetPrefix)) continue;
            list.add(key);
        }
        return list.toArray(new String[list.size()]);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ScriptEnhanceUIViewRoot sRoot = (ScriptEnhanceUIViewRoot)context.getViewRoot();
        ResponseWriter writer = context.getResponseWriter();
        String scriptKey = this.getScriptKey();
        if (!sRoot.containsScript(scriptKey)) {
            JavaScriptContext scriptContext = new JavaScriptContext();
            scriptContext.loadScript(scriptKey);
            sRoot.addScript(scriptKey, scriptContext);
            writer.write(sRoot.getAllScripts());
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        THtmlTree tree = (THtmlTree)component;
        if (!component.isRendered()) {
            return;
        }
        if (tree.getValue() == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String id = component.getId();
        boolean isOuterSpanUsed = false;
        if (id != null && !id.startsWith("_id")) {
            String clientId = component.getClientId(context);
            isOuterSpanUsed = true;
            writer.startElement("div", component);
            writer.writeAttribute("id", (Object)clientId, "id");
        }
        boolean showRootNode = tree.isShowRootNode();
        TreeModel model = tree.getDataModel();
        if (showRootNode) {
            this.encodeTree(context, writer, tree, null, 0);
        } else {
            tree.setNodeId(ROOT_NODE_ID);
            this.setRootNodeExpanded(tree, model);
            this.encodeEachTreeNode(context, tree);
        }
        this.resetCurrentNode(tree);
        if (isOuterSpanUsed) {
            writer.endElement("div");
        }
    }

    protected void setRootNodeExpanded(THtmlTree tree, TreeModel model) {
        String rootNodeId = tree.getNodeId();
        if (!model.isNodeExpanded(rootNodeId)) {
            model.toggleExpanded(rootNodeId);
        }
    }

    protected void encodeEachTreeNode(FacesContext context, THtmlTree tree) throws IOException {
        tree.setNodeId(ROOT_NODE_ID);
        TreeNode rootNode = tree.getNode();
        ResponseWriter writer = context.getResponseWriter();
        int num = 0;
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            this.encodeTree(context, writer, tree, ROOT_NODE_ID, num++);
        }
    }

    protected void resetCurrentNode(THtmlTree tree) {
        tree.setNodeId(null);
    }

    protected void encodeTree(FacesContext context, ResponseWriter out, THtmlTree tree, String parentId, int index) throws IOException {
        String nodeId = parentId != null ? parentId + ':' + index : ROOT_NODE_ID;
        String spanId = "teeda.extension.tree.TOGGLE_SPAN:" + tree.getId() + ":" + nodeId;
        tree.setNodeId(nodeId);
        TreeNode node = tree.getNode();
        this.beforeNodeEncode(context, out, tree);
        this.encodeCurrentNode(context, out, tree);
        this.afterNodeEncode(context, out);
        out.startElement("div", (UIComponent)tree);
        out.writeAttribute("id", (Object)spanId, null);
        if (tree.isNodeExpanded()) {
            RendererUtil.renderAttribute((ResponseWriter)out, (String)"style", (Object)"display:block");
        } else {
            RendererUtil.renderAttribute((ResponseWriter)out, (String)"style", (Object)"display:none");
        }
        final String id = spanId + ExtensionConstants.NAME_SEPARATOR + "treeExpanded";
        HtmlInputHidden hidden = new HtmlInputHidden(){

            public String getId() {
                return id;
            }

            public String getClientId(FacesContext context) {
                return id;
            }
        };
        hidden.setValue((Object)new Boolean(tree.isNodeExpanded()));
        hidden.setParent((UIComponent)tree);
        RendererUtil.renderChild((FacesContext)context, (UIComponent)hidden);
        String currentId = tree.getNodeId();
        int num = 0;
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.encodeTree(context, out, tree, currentId, num++);
        }
        out.endElement("div");
    }

    protected void encodeCurrentNode(FacesContext context, ResponseWriter out, THtmlTree tree) throws IOException {
        boolean showNav = tree.isShowNav();
        TreeNode node = tree.getNode();
        UIComponent nodeTypeFacet = tree.getFacet(node.getType());
        UIComponent nodeImgFacet = null;
        if (nodeTypeFacet == null) {
            throw new IllegalArgumentException("Unable to locate facet with the name: " + node.getType());
        }
        this.renderPadding(context, out, tree);
        if (showNav) {
            nodeImgFacet = this.encodeNavigation(context, out, tree);
        }
        this.renderEachNode(context, out, tree, nodeImgFacet, nodeTypeFacet);
    }

    protected void renderPadding(FacesContext context, ResponseWriter out, THtmlTree tree) throws IOException {
        int i;
        String nodeId = tree.getNodeId();
        String[] pathInfo = tree.getPathInformation(nodeId);
        boolean showRootNode = tree.isShowRootNode();
        boolean showLines = tree.isShowLines();
        int n = i = showRootNode ? 0 : 1;
        while (i < pathInfo.length - 1) {
            boolean lastChild = tree.isLastChild(pathInfo[i]);
            boolean shouldShowLineBackground = !lastChild && showLines;
            String contextPath = context.getExternalContext().getRequestContextPath();
            String lineSrc = contextPath + this.imageLocator.getLineBackgroundSrc(shouldShowLineBackground);
            out.startElement("td", (UIComponent)tree);
            out.writeAttribute("width", (Object)"19", null);
            out.writeAttribute("height", (Object)"100%", null);
            out.writeURIAttribute("background", (Object)lineSrc, null);
            out.startElement("img", (UIComponent)tree);
            out.writeURIAttribute("src", (Object)lineSrc, null);
            out.writeAttribute("width", (Object)"19", null);
            out.writeAttribute("height", (Object)"18", null);
            out.writeAttribute("border", (Object)ROOT_NODE_ID, null);
            out.endElement("img");
            out.endElement("td");
            ++i;
        }
    }

    protected void renderEachNode(FacesContext context, ResponseWriter out, THtmlTree tree, UIComponent nodeImgFacet, UIComponent nodeTypeFacet) throws IOException {
        out.startElement("td", (UIComponent)tree);
        if (nodeImgFacet != null) {
            RendererUtil.renderChild((FacesContext)context, (UIComponent)nodeImgFacet);
        }
        RendererUtil.renderChild((FacesContext)context, (UIComponent)nodeTypeFacet);
        out.endElement("td");
    }

    protected void beforeNodeEncode(FacesContext context, ResponseWriter out, THtmlTree tree) throws IOException {
        out.startElement("table", (UIComponent)tree);
        out.writeAttribute("cellpadding", (Object)ROOT_NODE_ID, null);
        out.writeAttribute("cellspacing", (Object)ROOT_NODE_ID, null);
        out.writeAttribute("border", (Object)ROOT_NODE_ID, null);
        out.startElement("tr", (UIComponent)tree);
    }

    protected void afterNodeEncode(FacesContext context, ResponseWriter out) throws IOException {
        out.endElement("tr");
        out.endElement("table");
    }

    protected HtmlGraphicImage createHtmlGraphicImage(String navSrc) {
        HtmlGraphicImage image = new HtmlGraphicImage();
        image.setId(IMAGE_PREFIX);
        image.setRendererType("org.seasar.teeda.extension.tree.Image");
        image.setUrl(navSrc);
        image.setWidth("19");
        image.setHeight("18");
        image.setBorder(0);
        return image;
    }

    private UIComponent encodeNavigation(FacesContext context, ResponseWriter out, THtmlTree tree) throws IOException {
        StringBuffer buf;
        UIComponent collapseFacet;
        String ownClientId = tree.getOwnClientId(context);
        String contextPath = context.getExternalContext().getRequestContextPath();
        TreeNode node = tree.getNode();
        String nodeId = tree.getNodeId();
        String markerId = this.getMarkerId(tree);
        UIComponent nodeTypeFacet = tree.getFacet(node.getType());
        UIComponent nodeImgFacet = null;
        this.imageLocator.setUpImageLocation(tree);
        String navSrc = this.imageLocator.getNavSrc();
        String altSrc = this.imageLocator.getAltSrc();
        boolean isClickable = this.imageLocator.isClickable();
        out.startElement("td", (UIComponent)tree);
        out.writeAttribute("width", (Object)"19", null);
        out.writeAttribute("height", (Object)"100%", null);
        out.writeAttribute("valign", (Object)"top", null);
        if (this.imageLocator.shouldRenderLineBackground()) {
            String img = contextPath + this.imageLocator.getLineBackgroundSrc(true);
            out.writeURIAttribute("background", (Object)img, null);
        }
        HtmlGraphicImage image = this.createHtmlGraphicImage(navSrc);
        String expandImgSrc = "";
        String collapseImgSrc = "";
        String nodeImageId = "";
        String expandImgUrl = null;
        String collapseImgUrl = null;
        UIComponent expandFacet = nodeTypeFacet.getFacet("expand");
        if (expandFacet != null) {
            UIGraphic expandImg = (UIGraphic)expandFacet;
            ViewHandler vh = context.getApplication().getViewHandler();
            expandImgUrl = expandImg.getUrl();
            expandImgSrc = vh.getResourceURL(context, expandImgUrl);
            if (expandImg.isRendered()) {
                expandImg.setId("t2x");
                expandImg.setParent((UIComponent)tree);
                nodeImageId = expandImg.getClientId(context);
                nodeImgFacet = expandFacet;
            }
        }
        if ((collapseFacet = nodeTypeFacet.getFacet("collapse")) != null) {
            UIGraphic collapseImg = (UIGraphic)collapseFacet;
            collapseImgUrl = collapseImg.getUrl();
            collapseImgSrc = context.getApplication().getViewHandler().getResourceURL(context, collapseImgUrl);
            if (collapseImg.isRendered()) {
                collapseImg.setId("t2c");
                collapseImg.setParent((UIComponent)tree);
                nodeImageId = collapseImg.getClientId(context);
                nodeImgFacet = collapseFacet;
            }
        }
        image.setParent((UIComponent)tree);
        String imageClientId = image.getClientId(context);
        if (isClickable) {
            out.startElement("a", (UIComponent)tree);
            out.writeAttribute("href", (Object)"#", null);
            buf = new StringBuffer();
            buf.append(NAMESPACE);
            buf.append("walkTreeNode(event, '");
            buf.append(imageClientId);
            buf.append("', this, '");
            buf.append(ownClientId);
            buf.append("', '");
            buf.append(markerId);
            buf.append("', '");
            buf.append(imageClientId);
            buf.append("', '");
            buf.append(navSrc);
            buf.append("', '");
            buf.append(nodeImageId);
            buf.append("', '");
            buf.append(expandImgUrl);
            buf.append("');");
            out.writeAttribute("onkeydown", (Object)buf.toString(), "");
        }
        if (node.getChildCount() > 0) {
            buf = new StringBuffer();
            buf.append(NAMESPACE);
            buf.append("treeNavClick('");
            buf.append(markerId);
            buf.append("', '");
            buf.append(imageClientId);
            buf.append("', '");
            buf.append(navSrc);
            buf.append("', '");
            buf.append(altSrc);
            buf.append("', '");
            buf.append(nodeImageId);
            buf.append("', '");
            buf.append(expandImgSrc);
            buf.append("', '");
            buf.append(collapseImgSrc);
            buf.append("', '");
            buf.append(tree.getId());
            buf.append("', '");
            buf.append(nodeId);
            buf.append("', '");
            buf.append(contextPath);
            buf.append("');");
            image.setOnclick(buf.toString());
            image.setStyle("cursor:hand;cursor:pointer");
        }
        RendererUtil.renderChild((FacesContext)context, (UIComponent)image);
        if (isClickable) {
            out.endElement("a");
        }
        out.endElement("td");
        return nodeImgFacet;
    }

    protected String getScriptKey() {
        return THtmlTree.class.getName();
    }

    public TreeNavigationImageLocator getImageLocator() {
        return this.imageLocator;
    }

    public void setImageLocator(TreeNavigationImageLocator imageLocator) {
        this.imageLocator = imageLocator;
    }

    protected String getMarkerId(UITreeData tree) {
        return TOGGLE_DIV + ExtensionConstants.NAME_SEPARATOR + tree.getId() + ExtensionConstants.NAME_SEPARATOR + tree.getNodeId();
    }
}

