/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.taglib;

import java.io.IOException;
import java.util.Locale;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.PageContextUtil;
import javax.faces.internal.ValueBindingUtil;
import javax.faces.internal.WebAppUtil;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.LocaleUtil;
import org.seasar.teeda.core.util.ContentTypeUtil;

public class TViewTag
extends UIComponentTag {
    private static final String COMPONENT_TYPE = "javax.faces.ViewRoot";
    protected String locale = null;

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getComponentType() {
        return COMPONENT_TYPE;
    }

    public String getRendererType() {
        return null;
    }

    public int doStartTag() throws JspException {
        int rc = 0;
        rc = super.doStartTag();
        FacesContext context = FacesContext.getCurrentInstance();
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        String encoding = PageContextUtil.getCharacterEncoding((PageContext)this.pageContext);
        this.pageContext.getResponse().setLocale(context.getViewRoot().getLocale());
        String acceptContentTypes = WebAppUtil.getAcceptHeader((FacesContext)context);
        String contentType = ContentTypeUtil.getContentType((String)acceptContentTypes);
        this.pageContext.getResponse().setContentType(contentType + "; charset=" + encoding);
        ResponseWriter writer = context.getResponseWriter();
        AssertionUtil.assertNotNull((String)"ResponseWriter", (Object)writer);
        try {
            writer.startDocument();
        }
        catch (IOException e) {
            throw new JspException(e.getMessage());
        }
        return rc;
    }

    public int doEndTag() throws JspException {
        FacesContext context = FacesContext.getCurrentInstance();
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        StateManager stateManager = context.getApplication().getStateManager();
        stateManager.saveSerializedView(context);
        JspWriter out = this.pageContext.getOut();
        try {
            out.flush();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        int rc = super.doEndTag();
        ResponseWriter responseWriter = context.getResponseWriter();
        AssertionUtil.assertNotNull((String)"ResponseWriter", (Object)responseWriter);
        try {
            responseWriter.endDocument();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        HttpSession session = null;
        session = this.pageContext.getSession();
        if (session != null) {
            session.setAttribute("javax.faces.request.charset", (Object)this.pageContext.getResponse().getCharacterEncoding());
        }
        return rc;
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        String localeStr = this.getLocale();
        FacesContext context = FacesContext.getCurrentInstance();
        Locale locale = (Locale)ValueBindingUtil.getValue((FacesContext)context, (String)localeStr);
        if (locale == null) {
            locale = LocaleUtil.getLocale((String)localeStr);
        }
        ((UIViewRoot)component).setLocale(locale);
        Config.set((ServletRequest)this.pageContext.getRequest(), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)locale);
    }
}

