/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.util;

import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ClassUtil;

public class PageTransitionUtil {
    private PageTransitionUtil() {
    }

    public static String getNextPageTransition(Class fromPageOrActionClass, Class toPageClass, NamingConvention nc) {
        if (fromPageOrActionClass == null || toPageClass == null) {
            return null;
        }
        String to = toPageClass.getName();
        String fromPackage = ClassUtil.getPackageName((Class)fromPageOrActionClass);
        String toPackage = ClassUtil.getPackageName((Class)toPageClass);
        String componentName = nc.fromClassNameToComponentName(to);
        String path = nc.fromPageNameToPath(componentName);
        if (fromPackage.equals(toPackage)) {
            int pos1 = path.lastIndexOf(47);
            int pos2 = path.lastIndexOf(46);
            String s = path.substring(0, pos2);
            return s.substring(pos1 + 1);
        }
        String viewRootPath = nc.getViewRootPath();
        if (!viewRootPath.endsWith("/")) {
            viewRootPath = viewRootPath + "/";
        }
        int pos1 = path.lastIndexOf(viewRootPath);
        int pos2 = path.lastIndexOf(46);
        String s = path.substring(0, pos2);
        if (pos1 == 0) {
            s = s.substring(viewRootPath.length());
        }
        return s.replaceAll("/", "_");
    }
}

