/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.OutputStreamUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.teeda.extension.render.html.THtmlHeadRenderer;

public abstract class VirtualResource {
    private static final String VIRTUAL_PATH = "/teedaExtension/";
    private static final String NAME = THtmlHeadRenderer.class.getName();
    private static final String JS_KEY = NAME + ".JS_KEY";
    private static final String INLINE_JS_KEY = NAME + ".INLINE_JS_KEY";
    private static final String CSS_KEY = NAME + ".CSS_KEY";
    private static final String INLINE_CSS_KEY = NAME + ".INLINE_CSS_KEY";

    protected VirtualResource() {
    }

    public static Set getJsResources(FacesContext context) {
        return VirtualResource.getSetResources(context, JS_KEY);
    }

    public static Set getCssResources(FacesContext context) {
        return VirtualResource.getSetResources(context, CSS_KEY);
    }

    public static Map getInlineJsResources(FacesContext context) {
        return VirtualResource.getMapResources(context, INLINE_JS_KEY);
    }

    public static Map getInlineCssResources(FacesContext context) {
        return VirtualResource.getMapResources(context, INLINE_CSS_KEY);
    }

    public static Collection getInlineJsResourceValues(FacesContext context) {
        return VirtualResource.getMapResources(context, INLINE_JS_KEY).values();
    }

    public static Collection getInlineCssResourceValues(FacesContext context) {
        return VirtualResource.getMapResources(context, INLINE_CSS_KEY).values();
    }

    protected static Set getSetResources(FacesContext context, String key) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"key", (Object)key);
        Map requestMap = context.getExternalContext().getRequestMap();
        LinkedHashSet resources = (LinkedHashSet)requestMap.get(key);
        if (resources == null) {
            resources = new LinkedHashSet();
            requestMap.put(key, resources);
        }
        return resources;
    }

    protected static Map getMapResources(FacesContext context, String key) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"key", (Object)key);
        Map requestMap = context.getExternalContext().getRequestMap();
        LinkedHashMap resources = (LinkedHashMap)requestMap.get(key);
        if (resources == null) {
            resources = new LinkedHashMap();
            requestMap.put(key, resources);
        }
        return resources;
    }

    public static void addJsResource(FacesContext context, String path) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"path", (Object)path);
        Set resources = VirtualResource.getJsResources(context);
        if (!resources.contains(path)) {
            resources.add(path);
        }
    }

    public static void addCssResource(FacesContext context, String path) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"path", (Object)path);
        Set resources = VirtualResource.getCssResources(context);
        if (!resources.contains(path)) {
            resources.add(path);
        }
    }

    public static void addInlineJsResource(FacesContext context, String key, String script) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"path", (Object)key);
        AssertionUtil.assertNotNull((String)"script", (Object)script);
        Map resources = VirtualResource.getInlineJsResources(context);
        if (!resources.containsKey(key)) {
            resources.put(key, script);
        }
    }

    public static void addInlineCssResource(FacesContext context, String key, String style) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"path", (Object)key);
        AssertionUtil.assertNotNull((String)"script", (Object)style);
        Map resources = VirtualResource.getInlineCssResources(context);
        if (!resources.containsKey(key)) {
            resources.put(key, style);
        }
    }

    public static String convertVirtualPath(FacesContext context, String path) {
        return context.getExternalContext().getRequestContextPath() + VIRTUAL_PATH + path;
    }

    public static boolean isVirtualPath(HttpServletRequest request) {
        return request.getRequestURI().indexOf(VIRTUAL_PATH) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resolveVirtualPath(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = VirtualResource.getResourcePath(request);
        String lcPath = path.toLowerCase();
        if (lcPath.endsWith(".js")) {
            response.setContentType("text/javascript");
        } else if (lcPath.endsWith(".css")) {
            response.setContentType("text/css");
        } else if (lcPath.endsWith(".gif")) {
            response.setContentType("image/gif");
        } else if (lcPath.endsWith(".png")) {
            response.setContentType("image/png");
        } else if (lcPath.endsWith(".jpg") || lcPath.endsWith(".jpeg")) {
            response.setContentType("image/jpeg");
        } else if (lcPath.endsWith(".xml") || lcPath.endsWith(".xsl")) {
            response.setContentType("text/xml");
        }
        response.setDateHeader("Last-Modified", 0L);
        Calendar expires = Calendar.getInstance();
        expires.add(5, 1);
        response.setDateHeader("Expires", expires.getTimeInMillis());
        InputStream is = ResourceUtil.getResourceAsStream((String)path);
        ServletOutputStream os = response.getOutputStream();
        try {
            InputStreamUtil.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            InputStreamUtil.close((InputStream)is);
            OutputStreamUtil.close((OutputStream)os);
        }
    }

    protected static String getResourcePath(HttpServletRequest request) {
        String uri = request.getRequestURI();
        int pos = uri.indexOf(VIRTUAL_PATH) + VIRTUAL_PATH.length();
        return uri.substring(pos);
    }
}

