/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.validator;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.ValidatorException;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.exception.ExtendValidatorException;
import org.seasar.teeda.extension.util.ValidatorUtil;

public class TLengthValidator
extends LengthValidator {
    private String target;
    private String[] targets;
    private String maximumMessageId;
    private String minimumMessageId;

    public TLengthValidator() {
    }

    public TLengthValidator(int maximum) {
        super(maximum);
    }

    public TLengthValidator(int maximum, int minimum) {
        super(maximum, minimum);
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        if (!ValidatorUtil.isTargetCommand(context, this.targets)) {
            return;
        }
        try {
            super.validate(context, component, value);
        }
        catch (ValidatorException e) {
            throw new ExtendValidatorException(e.getFacesMessage(), e, new String[]{this.maximumMessageId, this.minimumMessageId});
        }
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this.target, this.maximumMessageId, this.minimumMessageId};
        return state;
    }

    public void restoreState(FacesContext context, Object obj) {
        Object[] state = (Object[])obj;
        super.restoreState(context, state[0]);
        this.target = (String)state[1];
        this.setTarget(this.target);
        this.maximumMessageId = (String)state[2];
        this.minimumMessageId = (String)state[3];
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        if (StringUtil.isEmpty((String)target)) {
            return;
        }
        this.targets = StringUtil.split((String)target, (String)", ");
    }

    public String getMaximumMessageId() {
        return !StringUtil.isEmpty((String)this.maximumMessageId) ? this.maximumMessageId : "javax.faces.validator.LengthValidator.MAXIMUM";
    }

    public String getMinimumMessageId() {
        return !StringUtil.isEmpty((String)this.minimumMessageId) ? this.minimumMessageId : "javax.faces.validator.LengthValidator.MINIMUM";
    }

    public void setMaximumMessageId(String maximumMessageId) {
        this.maximumMessageId = maximumMessageId;
    }

    public void setMinimumMessageId(String minimumMessageId) {
        this.minimumMessageId = minimumMessageId;
    }
}

