/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.validator;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.LongRangeValidator;
import javax.faces.validator.ValidatorException;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.exception.ExtendValidatorException;
import org.seasar.teeda.extension.util.ValidatorUtil;
import org.seasar.teeda.extension.validator.ValidationTargetSelectable;

public class TLongRangeValidator
extends LongRangeValidator
implements ValidationTargetSelectable {
    private String target;
    private String[] targets;
    private String maximumMessageId;
    private String minimumMessageId;
    private String notInRangeMessageId;
    private String typeMessageId;
    private boolean convert = true;

    public TLongRangeValidator() {
    }

    public TLongRangeValidator(long maximum) {
        super(maximum);
    }

    public TLongRangeValidator(long maximum, long minimum) {
        super(maximum, minimum);
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        if (!this.isTargetCommandValidation(context, this.targets)) {
            return;
        }
        try {
            super.validate(context, component, value);
        }
        catch (ValidatorException e) {
            throw new ExtendValidatorException(e.getFacesMessage(), e, new String[]{this.maximumMessageId, this.minimumMessageId, this.notInRangeMessageId, this.typeMessageId});
        }
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this.target, this.maximumMessageId, this.minimumMessageId, this.notInRangeMessageId, this.typeMessageId, new Boolean(this.convert)};
        return state;
    }

    public void restoreState(FacesContext context, Object obj) {
        Object[] state = (Object[])obj;
        super.restoreState(context, state[0]);
        this.target = (String)state[1];
        this.setTarget(this.target);
        this.maximumMessageId = (String)state[2];
        this.minimumMessageId = (String)state[3];
        this.notInRangeMessageId = (String)state[4];
        this.typeMessageId = (String)state[5];
        this.convert = (Boolean)state[6];
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        if (StringUtil.isEmpty((String)target)) {
            return;
        }
        this.targets = StringUtil.split((String)target, (String)", ");
    }

    public String getMaximumMessageId() {
        return !StringUtil.isEmpty((String)this.maximumMessageId) ? this.maximumMessageId : "javax.faces.validator.LongRangeValidator.MAXIMUM";
    }

    public String getMinimumMessageId() {
        return !StringUtil.isEmpty((String)this.minimumMessageId) ? this.minimumMessageId : "javax.faces.validator.LongRangeValidator.MINIMUM";
    }

    public String getNotInRangeMessageId() {
        return !StringUtil.isEmpty((String)this.notInRangeMessageId) ? this.notInRangeMessageId : "javax.faces.validator.NOT_IN_RANGE";
    }

    public String getTypeMessageId() {
        return !StringUtil.isEmpty((String)this.typeMessageId) ? this.typeMessageId : "javax.faces.validator.LongRangeValidator.TYPE";
    }

    public void setMaximumMessageId(String maximumMessageId) {
        this.maximumMessageId = maximumMessageId;
    }

    public void setMinimumMessageId(String minimumMessageId) {
        this.minimumMessageId = minimumMessageId;
    }

    public void setNotInRangeMessageId(String notInRangeMessageId) {
        this.notInRangeMessageId = notInRangeMessageId;
    }

    public void setTypeMessageId(String typeMessageId) {
        this.typeMessageId = typeMessageId;
    }

    public boolean isConvert() {
        return this.convert;
    }

    public void setConvert(boolean convert) {
        this.convert = convert;
    }

    protected Object[] convertArgs(Object[] args) {
        return this.isConvert() ? this.convert(args) : args;
    }

    protected Object[] convert(Object[] args) {
        Object[] ret = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Long) {
                long l = (Long)args[i];
                ret[i] = String.valueOf(l);
                continue;
            }
            ret[i] = args[i];
        }
        return ret;
    }

    public boolean isTargetCommandValidation(FacesContext context, String[] targets) {
        return ValidatorUtil.isTargetCommand(context, targets);
    }
}

