/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesMessageUtil;
import javax.faces.internal.UIComponentUtil;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.util.PatternUtil;
import org.seasar.teeda.extension.exception.ExtendValidatorException;
import org.seasar.teeda.extension.util.ValidatorUtil;
import org.seasar.teeda.extension.validator.ValidationTargetSelectable;

public class TRegularExpressionValidator
implements Validator,
StateHolder,
ValidationTargetSelectable {
    public static final String VALIDATOR_ID = TRegularExpressionValidator.class.getName();
    public static final String REGULAR_EXPRRESSION_MESSAGE_ID = VALIDATOR_ID + ".INVALID";
    private boolean transientValue = false;
    private String pattern;
    private String target;
    private String[] targets;
    private String messageId;

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        if (value == null) {
            return;
        }
        if (!this.isTargetCommandValidation(context, this.targets)) {
            return;
        }
        String strValue = value.toString();
        if (!PatternUtil.matches((String)this.getPattern(), (CharSequence)strValue)) {
            Object[] args = new Object[]{this.getPattern(), UIComponentUtil.getLabel((UIComponent)component)};
            String msgId = this.messageId != null ? this.messageId : REGULAR_EXPRRESSION_MESSAGE_ID;
            FacesMessage message = FacesMessageUtil.getMessage((FacesContext)context, (String)msgId, (Object[])args);
            throw new ExtendValidatorException(message, new String[]{msgId});
        }
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{this.pattern, this.target, this.messageId};
        return state;
    }

    public void restoreState(FacesContext context, Object obj) {
        Object[] state = (Object[])obj;
        this.pattern = (String)state[0];
        this.target = (String)state[1];
        this.setTarget(this.target);
        this.messageId = (String)state[2];
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        if (StringUtil.isEmpty((String)target)) {
            return;
        }
        this.targets = StringUtil.split((String)target, (String)", ");
    }

    public String getMessageId() {
        return !StringUtil.isEmpty((String)this.messageId) ? this.messageId : REGULAR_EXPRRESSION_MESSAGE_ID;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public boolean isTargetCommandValidation(FacesContext context, String[] targets) {
        return ValidatorUtil.isTargetCommand(context, targets);
    }
}

