/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Currency;
import java.util.Locale;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.internal.ConvertUtil;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.NumberConversionUtil;

public class NumberConverter
implements Converter,
StateHolder {
    public static final String CONVERTER_ID = "javax.faces.Number";
    private Locale locale = null;
    private String pattern = null;
    private String type = null;
    private String currencyCode = null;
    private String currencySymbol = null;
    private boolean isIntegerOnly = false;
    private boolean isTransient = false;
    private boolean isGroupingUsed = false;
    private int maxFractionDigits = 0;
    private int maxIntegerDigits = 0;
    private int minFractionDigits = 0;
    private int minIntegerDigits = 0;
    private static final String TYPE_CURRENCY = "currency";
    private static final String TYPE_NUMBER = "number";
    private static final String TYPE_PERCENT = "percent";
    private boolean isSetMaxFractionDigits = false;
    private boolean isSetMaxIntegerDigits = false;
    private boolean isSetMinFractionDigits = false;
    private boolean isSetMinIntegerDigits = false;

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        AssertionUtil.assertNotNull((String)"UIComponent", (Object)component);
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return null;
        }
        Locale locale = this.getLocale(context);
        value = NumberConversionUtil.removeDelimeter((String)value, (Locale)locale);
        NumberFormat formatter = this.getNumberFormat(locale);
        formatter.setParseIntegerOnly(this.isIntegerOnly());
        try {
            return formatter.parse(value);
        }
        catch (ParseException e) {
            Object[] args = ConvertUtil.createExceptionMessageArgs(component, value);
            throw ConvertUtil.wrappedByConverterException(this, context, args, e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        AssertionUtil.assertNotNull((String)"UIComponent", (Object)component);
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        Locale locale = this.getLocale(context);
        String pattern = this.getPattern();
        NumberFormat formatter = this.getNumberFormat(locale);
        if (pattern == null) {
            this.configureFormatter(formatter);
            if (TYPE_CURRENCY.equals(this.type)) {
                this.configureCurrency(formatter);
            }
        }
        try {
            return formatter.format(value);
        }
        catch (Exception e) {
            throw ConvertUtil.wrappedByConverterException(e);
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.getCurrencyCode(), this.getCurrencySymbol(), this.isGroupingUsed() ? Boolean.TRUE : Boolean.FALSE, this.isIntegerOnly() ? Boolean.TRUE : Boolean.FALSE, new Integer(this.getMaxFractionDigits()), this.isSetMaxFractionDigits ? Boolean.TRUE : Boolean.FALSE, new Integer(this.getMaxIntegerDigits()), this.isSetMaxIntegerDigits ? Boolean.TRUE : Boolean.FALSE, new Integer(this.getMinFractionDigits()), this.isSetMinFractionDigits ? Boolean.TRUE : Boolean.FALSE, new Integer(this.getMinIntegerDigits()), this.isSetMinIntegerDigits ? Boolean.TRUE : Boolean.FALSE, this.getLocale(), this.getPattern(), this.getType()};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.currencyCode = (String)values[0];
        this.currencySymbol = (String)values[1];
        this.isGroupingUsed = (Boolean)values[2];
        this.isIntegerOnly = (Boolean)values[3];
        this.maxFractionDigits = (Integer)values[4];
        this.isSetMaxFractionDigits = (Boolean)values[5];
        this.maxIntegerDigits = (Integer)values[6];
        this.isSetMaxIntegerDigits = (Boolean)values[7];
        this.minFractionDigits = (Integer)values[8];
        this.isSetMinFractionDigits = (Boolean)values[9];
        this.minIntegerDigits = (Integer)values[10];
        this.isSetMinIntegerDigits = (Boolean)values[11];
        this.locale = (Locale)values[12];
        this.pattern = (String)values[13];
        this.type = (String)values[14];
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isIntegerOnly() {
        return this.isIntegerOnly;
    }

    public void setIntegerOnly(boolean isIntegerOnly) {
        this.isIntegerOnly = isIntegerOnly;
    }

    public boolean isGroupingUsed() {
        return this.isGroupingUsed;
    }

    public void setGroupingUsed(boolean isGroupingUsed) {
        this.isGroupingUsed = isGroupingUsed;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public int getMaxFractionDigits() {
        return this.maxFractionDigits;
    }

    public void setMaxFractionDigits(int maxFractionDigits) {
        this.maxFractionDigits = maxFractionDigits;
        this.isSetMaxFractionDigits = true;
    }

    public int getMaxIntegerDigits() {
        return this.maxIntegerDigits;
    }

    public void setMaxIntegerDigits(int maxIntegerDigits) {
        this.maxIntegerDigits = maxIntegerDigits;
        this.isSetMaxIntegerDigits = true;
    }

    public int getMinFractionDigits() {
        return this.minFractionDigits;
    }

    public void setMinFractionDigits(int minFractionDigits) {
        this.minFractionDigits = minFractionDigits;
        this.isSetMinFractionDigits = true;
    }

    public int getMinIntegerDigits() {
        return this.minIntegerDigits;
    }

    public void setMinIntegerDigits(int minIntegerDigits) {
        this.minIntegerDigits = minIntegerDigits;
        this.isSetMinIntegerDigits = true;
    }

    private Locale getLocale(FacesContext context) {
        Locale locale = this.getLocale();
        if (locale != null) {
            return locale;
        }
        return context.getViewRoot().getLocale();
    }

    private NumberFormat getNumberFormat(Locale locale) {
        if (this.pattern != null) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            return new DecimalFormat(this.pattern, symbols);
        }
        if (this.type != null) {
            return this.getNumberFormatForType();
        }
        throw new ConverterException("NumberFormat not found");
    }

    private NumberFormat getNumberFormatForType() {
        if (this.type.equals(TYPE_CURRENCY)) {
            return NumberFormat.getCurrencyInstance();
        }
        if (this.type.equals(TYPE_NUMBER)) {
            return NumberFormat.getNumberInstance();
        }
        if (this.type.equals(TYPE_PERCENT)) {
            return NumberFormat.getPercentInstance();
        }
        throw new ConverterException(new IllegalArgumentException());
    }

    protected void configureFormatter(NumberFormat formatter) {
        formatter.setGroupingUsed(this.isGroupingUsed());
        this.setMaximumFractionDigitsToFormatter(formatter);
        this.setMaximumIntegerDigitsToFormatter(formatter);
        this.setMinimumFractionDigitsToFormatter(formatter);
        this.setMinimumIntegerDigitsToFormatter(formatter);
    }

    protected void setMaximumFractionDigitsToFormatter(NumberFormat formatter) {
        if (this.isSetMaxFractionDigits) {
            formatter.setMaximumFractionDigits(this.getMaxFractionDigits());
        }
    }

    protected void setMaximumIntegerDigitsToFormatter(NumberFormat formatter) {
        if (this.isSetMaxIntegerDigits) {
            formatter.setMaximumIntegerDigits(this.getMaxIntegerDigits());
        }
    }

    protected void setMinimumFractionDigitsToFormatter(NumberFormat formatter) {
        if (this.isSetMinFractionDigits) {
            formatter.setMinimumFractionDigits(this.getMinFractionDigits());
        }
    }

    protected void setMinimumIntegerDigitsToFormatter(NumberFormat formatter) {
        if (this.isSetMinIntegerDigits) {
            formatter.setMinimumIntegerDigits(this.getMinIntegerDigits());
        }
    }

    protected void configureCurrency(NumberFormat formatter) {
        boolean isCurrencyCodeUse = false;
        String currencyCode = this.getCurrencyCode();
        String currencySymbol = this.getCurrencySymbol();
        if (currencyCode == null && currencySymbol == null) {
            return;
        }
        if (this.isSetBothCurrencyProperties() && NumberConverter.isJava14()) {
            isCurrencyCodeUse = currencyCode != null;
        } else {
            boolean bl = isCurrencyCodeUse = currencySymbol == null;
        }
        if (isCurrencyCodeUse) {
            formatter.setCurrency(Currency.getInstance(currencyCode));
        } else {
            DecimalFormat df = (DecimalFormat)formatter;
            DecimalFormatSymbols symbols = df.getDecimalFormatSymbols();
            symbols.setCurrencySymbol(currencySymbol);
            df.setDecimalFormatSymbols(symbols);
        }
    }

    protected boolean isSetBothCurrencyProperties() {
        return this.getCurrencyCode() != null && this.getCurrencySymbol() != null;
    }

    protected static boolean isJava14() {
        try {
            Class<?> clazz = Class.forName("java.util.Currency");
            return clazz != null;
        }
        catch (Exception ignore) {
            return false;
        }
    }
}

