/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import org.seasar.framework.util.AssertionUtil;

public class ComponentChildrenListWrapper
extends AbstractList
implements Serializable {
    private static final long serialVersionUID = 3617294519188666163L;
    private final List list = new ArrayList();
    private final UIComponent parent;

    public ComponentChildrenListWrapper(UIComponent parent) {
        this.parent = parent;
    }

    public Object get(int index) {
        return this.list.get(index);
    }

    public Object remove(int index) {
        UIComponent child = (UIComponent)this.list.remove(index);
        if (child != null) {
            child.setParent(null);
        }
        return child;
    }

    public int size() {
        return this.list.size();
    }

    public void add(int index, Object child) {
        this.assertUIComponent(child);
        this.setNewParent((UIComponent)child);
        this.list.add(index, child);
    }

    public boolean add(Object child) {
        this.assertUIComponent(child);
        this.setNewParent((UIComponent)child);
        return this.list.add(child);
    }

    public boolean addAll(Collection children) {
        boolean changed = false;
        Iterator it = children.iterator();
        while (it.hasNext()) {
            Object child = it.next();
            this.assertUIComponent(child);
            this.add(child);
            changed = true;
        }
        return changed;
    }

    private void setNewParent(UIComponent child) {
        UIComponent oldParent = child.getParent();
        if (oldParent != null) {
            this.removeFromParent(oldParent, child);
        }
        child.setParent(this.parent);
    }

    private void removeFromParent(UIComponent parent, UIComponent child) {
        parent.getChildren().remove(child);
    }

    private void assertUIComponent(Object obj) {
        AssertionUtil.assertNotNull((String)"value", (Object)obj);
        if (!(obj instanceof UIComponent)) {
            throw new ClassCastException(obj.getClass().getName());
        }
    }
}

