/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.internal.ComponentStatesHolder;
import javax.faces.internal.NamingContainerUtil;
import javax.faces.internal.SavedState;

public class ComponentStates {
    public static final int DEFAULT_INITIAL_CAPACITY = 1024;
    private Map savedStates;

    public ComponentStates() {
        this(1024);
    }

    public ComponentStates(int initialCapacity) {
        this.savedStates = new HashMap(initialCapacity);
    }

    public void restoreDescendantState(FacesContext context, UIComponent component) {
        Iterator it = component.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            NamingContainerUtil.refreshClientId(child);
            if (child instanceof ComponentStatesHolder) continue;
            if (child instanceof EditableValueHolder) {
                EditableValueHolder holder = (EditableValueHolder)((Object)child);
                String clientId = child.getClientId(context);
                SavedState state = (SavedState)this.savedStates.get(clientId);
                if (state == null) {
                    state = new SavedState();
                    this.savedStates.put(clientId, state);
                }
                state.restore(holder);
            }
            this.restoreDescendantState(context, child);
        }
    }

    public void saveDescendantComponentStates(FacesContext context, UIComponent component) {
        Iterator it = component.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (child instanceof EditableValueHolder) {
                EditableValueHolder holder = (EditableValueHolder)((Object)child);
                SavedState state = new SavedState();
                String clientId = child.getClientId(context);
                state.save(holder);
                this.savedStates.put(clientId, state);
            }
            this.saveDescendantComponentStates(context, child);
        }
    }

    public void clear() {
        this.savedStates.clear();
    }
}

