/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.Map;
import java.util.Random;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.util.StringUtil;

public class WindowIdUtil {
    public static final String NEWWINDOW = "newwindow";
    public static final String TEEDA_WID = "TEEDA_WID";
    private static final String BLANK = "_blank";
    private static final String base = String.valueOf(System.currentTimeMillis());
    private static Random random = new Random();
    private static Long sequence = new Long(0L);
    private static String currentWindowId;

    protected WindowIdUtil() {
    }

    public static String setupWindowId(ExternalContext externalContext) throws FacesException {
        String wid = null;
        if (WindowIdUtil.needNewWindow(externalContext.getRequestParameterMap())) {
            wid = WindowIdUtil.createWindowId();
            Object response = externalContext.getResponse();
            if (response instanceof HttpServletResponse) {
                HttpServletResponse res = (HttpServletResponse)response;
                Cookie cookie = new Cookie(TEEDA_WID, wid);
                String contextPath = externalContext.getRequestContextPath();
                cookie.setPath(contextPath);
                res.addCookie(cookie);
            }
        } else {
            Cookie cookie;
            Map cookieMap = externalContext.getRequestCookieMap();
            if (cookieMap != null && (cookie = (Cookie)cookieMap.get(TEEDA_WID)) != null) {
                wid = cookie.getValue();
            }
        }
        WindowIdUtil.setWindowId(externalContext, wid);
        return wid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createWindowId() {
        Random random = WindowIdUtil.random;
        synchronized (random) {
            sequence = new Long(sequence + 1L);
            currentWindowId = base + sequence + WindowIdUtil.random.nextLong();
            return currentWindowId;
        }
    }

    public static void setWindowId(ExternalContext externalContext, String wid) throws FacesException {
        Map requestMap = externalContext.getRequestMap();
        requestMap.put(TEEDA_WID, wid);
    }

    public static String getWindowId(ExternalContext externalContext) throws FacesException {
        Map requestMap = externalContext.getRequestMap();
        return (String)requestMap.get(TEEDA_WID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentWindowId() {
        Random random = WindowIdUtil.random;
        synchronized (random) {
            return currentWindowId;
        }
    }

    public static boolean isNewWindowTarget(String target) {
        if (StringUtil.isEmpty((String)target)) {
            return false;
        }
        return BLANK.equals(target) || target.charAt(0) != '_';
    }

    public static boolean needNewWindow(Map parameterMap) {
        String newwindow = (String)parameterMap.get(NEWWINDOW);
        return "true".equals(newwindow);
    }
}

