/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal.scope;

import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.internal.WindowIdUtil;
import org.seasar.framework.util.LruHashMap;

public class VariableScope {
    private String key;
    private int windowSize = 20;

    public VariableScope(String key) {
        this.key = key;
    }

    public VariableScope(String key, int windowSize) {
        this.key = key;
        this.windowSize = windowSize;
    }

    public Map getContext(FacesContext context) throws FacesException {
        ExternalContext extCtx = context.getExternalContext();
        Map contexts = this.getContexts(extCtx);
        String wid = WindowIdUtil.getWindowId(extCtx);
        return (Map)contexts.get(wid);
    }

    public Map getOrCreateContext(FacesContext context) throws FacesException {
        String wid;
        ExternalContext extCtx = context.getExternalContext();
        Map contexts = this.getContexts(extCtx);
        HashMap ctx = (HashMap)contexts.get(wid = WindowIdUtil.getWindowId(extCtx));
        if (ctx == null) {
            ctx = new HashMap();
            contexts.put(wid, ctx);
        }
        return ctx;
    }

    public void removeContext(FacesContext context) throws FacesException {
        ExternalContext extCtx = context.getExternalContext();
        String wid = WindowIdUtil.getWindowId(extCtx);
        this.removeContext(context, wid);
    }

    public void removeContext(FacesContext context, String wid) throws FacesException {
        ExternalContext extCtx = context.getExternalContext();
        Map contexts = this.getContexts(extCtx);
        contexts.remove(wid);
    }

    protected Map getContexts(ExternalContext externalContext) throws FacesException {
        Map sessionMap = externalContext.getSessionMap();
        Map contexts = (Map)sessionMap.get(this.key);
        if (contexts == null) {
            contexts = new LruHashMap(this.windowSize);
            sessionMap.put(this.key, contexts);
        }
        return contexts;
    }
}

