/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesMessageUtil;
import javax.faces.internal.UIComponentUtil;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.LongConversionUtil;

public class LongRangeValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "javax.faces.LongRange";
    public static final String TYPE_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.TYPE";
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.MINIMUM";
    private long maximum = Long.MAX_VALUE;
    private long minimum = Long.MIN_VALUE;
    private boolean transientValue = false;

    public LongRangeValidator() {
    }

    public LongRangeValidator(long maximum) {
        this.maximum = maximum;
    }

    public LongRangeValidator(long maximum, long minimum) {
        this.maximum = maximum;
        this.minimum = minimum;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        if (value == null) {
            return;
        }
        long longValue = 0L;
        try {
            longValue = LongConversionUtil.toLong((Object)value);
            if (this.maximum < Long.MAX_VALUE && this.minimum > Long.MIN_VALUE) {
                if (longValue < this.minimum || longValue > this.maximum) {
                    Object[] args = new Object[]{new Long(this.minimum), new Long(this.maximum), UIComponentUtil.getLabel(component)};
                    FacesMessage message = FacesMessageUtil.getMessage(context, this.getNotInRangeMessageId(), this.convertArgs(args));
                    throw new ValidatorException(message, this.getNotInRangeMessageId(), args);
                }
            } else if (this.minimum > Long.MIN_VALUE) {
                if (longValue < this.minimum) {
                    Object[] args = new Object[]{new Long(this.minimum), UIComponentUtil.getLabel(component)};
                    FacesMessage message = FacesMessageUtil.getMessage(context, this.getMinimumMessageId(), this.convertArgs(args));
                    throw new ValidatorException(message, this.getMinimumMessageId(), args);
                }
            } else if (this.maximum < Long.MAX_VALUE && longValue > this.maximum) {
                Object[] args = new Object[]{new Long(this.maximum), UIComponentUtil.getLabel(component)};
                FacesMessage message = FacesMessageUtil.getMessage(context, this.getMaximumMessageId(), this.convertArgs(args));
                throw new ValidatorException(message, this.getMaximumMessageId(), args);
            }
        }
        catch (NumberFormatException e) {
            Object[] args = new Object[]{UIComponentUtil.getLabel(component)};
            throw new ValidatorException(FacesMessageUtil.getMessage(context, this.getTypeMessageId(), args), this.getTypeMessageId(), args);
        }
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{new Long(this.maximum), new Long(this.minimum)};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.maximum = (Long)values[0];
        this.minimum = (Long)values[1];
    }

    public long getMaximum() {
        return this.maximum;
    }

    public long getMinimum() {
        return this.minimum;
    }

    public void setMaximum(long maximum) {
        this.maximum = maximum;
    }

    public void setMinimum(long minimum) {
        this.minimum = minimum;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LongRangeValidator)) {
            return false;
        }
        LongRangeValidator v = (LongRangeValidator)obj;
        return this.maximum == v.maximum && this.minimum == v.minimum;
    }

    public int hashCode() {
        return (int)this.maximum * (int)this.minimum * 17;
    }

    protected String getMaximumMessageId() {
        return MAXIMUM_MESSAGE_ID;
    }

    protected String getMinimumMessageId() {
        return MINIMUM_MESSAGE_ID;
    }

    protected String getNotInRangeMessageId() {
        return "javax.faces.validator.NOT_IN_RANGE";
    }

    protected String getTypeMessageId() {
        return TYPE_MESSAGE_ID;
    }

    protected Object[] convertArgs(Object[] args) {
        return args;
    }
}

