/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.application.ComponentLookupStrategy;
import org.seasar.teeda.core.util.DIContainerUtil;

public class DefaultComponentLookupStrategy
implements ComponentLookupStrategy {
    private List namespaces = new ArrayList();

    public DefaultComponentLookupStrategy() {
        this.namespaces.add("teeda");
    }

    public Object getComponentByName(String componentName) {
        if (StringUtil.isEmpty((String)componentName)) {
            throw new IllegalArgumentException();
        }
        Object component = DIContainerUtil.getComponentNoException(componentName);
        if (component != null) {
            return component;
        }
        Iterator itr = this.namespaces.iterator();
        while (itr.hasNext()) {
            String namespace = (String)itr.next();
            component = this.getComponentByDefaultNamespace(namespace, componentName);
            if (component == null) continue;
            return component;
        }
        return null;
    }

    public Object getComponentByClass(Class componentClazz) {
        if (componentClazz == null) {
            throw new IllegalArgumentException();
        }
        return DIContainerUtil.getComponentNoException(componentClazz);
    }

    public void addNamespace(String namespace) {
        if (!StringUtil.isEmpty((String)namespace)) {
            this.namespaces.add(namespace);
        }
    }

    private Object getComponentByDefaultNamespace(String namespace, String componentName) {
        return DIContainerUtil.getComponentNoException(namespace + "." + componentName);
    }
}

