/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application.impl;

import java.io.IOException;
import javax.faces.application.StateManager;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;
import org.seasar.teeda.core.application.TeedaStateManager;
import org.seasar.teeda.core.application.TreeStructure;
import org.seasar.teeda.core.util.ResponseStateManagerUtil;
import org.seasar.teeda.core.util.StateManagerUtil;

public class TeedaSessionStateManagerImpl
extends TeedaStateManager {
    static final long serialVersionUID = 0L;

    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        TeedaSessionStateManagerImpl.assertRenderKitIdNotNull(renderKitId);
        UIViewRoot viewRoot = this.restoreTreeStructure(context, viewId, renderKitId);
        if (viewRoot != null) {
            viewRoot.setViewId(viewId);
            this.restoreComponentState(context, viewRoot, renderKitId);
            if (!this.isSavingStateInClient(context)) {
                ExternalContext extContext = context.getExternalContext();
                this.removeSerializedViewFromServer(extContext, viewId);
            }
        }
        return viewRoot;
    }

    public StateManager.SerializedView saveSerializedView(FacesContext context) throws IllegalStateException {
        UIViewRoot viewRoot = context.getViewRoot();
        StateManagerUtil.assertComponentNoDuplicateId(viewRoot);
        Object struct = this.getTreeStructureToSave(context);
        Object state = this.getComponentStateToSave(context);
        StateManager.SerializedView serializedView = new StateManager.SerializedView(struct, state);
        if (this.isSavingStateInClient(context)) {
            return serializedView;
        }
        ExternalContext externalContext = context.getExternalContext();
        this.saveSerializedViewToServer(externalContext, viewRoot.getViewId(), serializedView);
        return null;
    }

    public void writeState(FacesContext context, StateManager.SerializedView serializedView) throws IOException {
        if (this.isSavingStateInClient(context)) {
            UIViewRoot viewRoot = context.getViewRoot();
            ResponseStateManager responseStateManager = ResponseStateManagerUtil.getResponseStateManager(context, viewRoot.getRenderKitId());
            responseStateManager.writeState(context, serializedView);
        }
    }

    protected Object getComponentStateToSave(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        return viewRoot.processSaveState(context);
    }

    protected Object getTreeStructureToSave(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        return this.getTreeStructureManager().buildTreeStructure(viewRoot);
    }

    protected void restoreComponentState(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
        TeedaSessionStateManagerImpl.assertRenderKitIdNotNull(renderKitId);
        if (viewRoot.getRenderKitId() == null) {
            viewRoot.setRenderKitId(renderKitId);
        }
        if (this.isSavingStateInClient(context)) {
            this.restoreComponentStateFromClient(context, viewRoot, renderKitId);
        } else {
            this.restoreComponentStateFromServer(context, viewRoot);
        }
    }

    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        TeedaSessionStateManagerImpl.assertRenderKitIdNotNull(renderKitId);
        if (this.isSavingStateInClient(context)) {
            return this.restoreTreeStructureFromClient(context, viewId, renderKitId);
        }
        return this.restoreTreeStructureFromServer(context, viewId);
    }

    protected void restoreComponentStateFromClient(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
        ResponseStateManager responseStateManager = ResponseStateManagerUtil.getResponseStateManager(context, renderKitId);
        Object state = responseStateManager.getComponentStateToRestore(context);
        viewRoot.processRestoreState(context, state);
    }

    protected void restoreComponentStateFromServer(FacesContext context, UIViewRoot viewRoot) {
        StateManager.SerializedView serializedView = this.getSerializedViewFromServer(context.getExternalContext(), viewRoot.getViewId());
        if (serializedView == null) {
            return;
        }
        Object state = serializedView.getState();
        if (state == null) {
            return;
        }
        viewRoot.processRestoreState(context, state);
    }

    protected UIViewRoot restoreTreeStructureFromClient(FacesContext context, String viewId, String renderKitId) {
        ResponseStateManager responseStateManager = ResponseStateManagerUtil.getResponseStateManager(context, renderKitId);
        TreeStructure struct = (TreeStructure)responseStateManager.getTreeStructureToRestore(context, viewId);
        if (struct == null) {
            return null;
        }
        return (UIViewRoot)this.getTreeStructureManager().restoreTreeStructure(struct);
    }

    protected UIViewRoot restoreTreeStructureFromServer(FacesContext context, String viewId) {
        StateManager.SerializedView serializedView = this.getSerializedViewFromServer(context.getExternalContext(), viewId);
        if (serializedView == null) {
            return null;
        }
        TreeStructure struct = (TreeStructure)serializedView.getStructure();
        return (UIViewRoot)this.getTreeStructureManager().restoreTreeStructure(struct);
    }

    private static void assertRenderKitIdNotNull(String renderKitId) {
        if (renderKitId == null) {
            throw new IllegalArgumentException();
        }
    }

    protected StateManager.SerializedView getSerializedViewFromServer(ExternalContext externalContext, String viewId) {
        return (StateManager.SerializedView)externalContext.getSessionMap().get(SERIALIZED_VIEW_ATTR + "-" + viewId);
    }

    protected void saveSerializedViewToServer(ExternalContext externalContext, String viewId, StateManager.SerializedView serializedView) {
        externalContext.getSessionMap().put(SERIALIZED_VIEW_ATTR + "-" + viewId, serializedView);
    }

    protected void removeSerializedViewFromServer(ExternalContext externalContext, String viewId) {
        externalContext.getSessionMap().remove(SERIALIZED_VIEW_ATTR + "-" + viewId);
    }

    public void removeSerializedView(String viewId) {
        FacesContext.getCurrentInstance().getExternalContext().getSessionMap().remove(viewId);
    }
}

