/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.lifecycle;

import java.util.Iterator;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import org.seasar.teeda.core.lifecycle.Phase;
import org.seasar.teeda.core.util.LifecycleUtil;

public abstract class AbstractPhase
implements Phase {
    public final void prePhase(FacesContext context) {
        Lifecycle lifecycle = this.getLifecycle();
        PhaseListener[] phaseListeners = lifecycle.getPhaseListeners();
        if (phaseListeners != null) {
            for (int i = 0; i < phaseListeners.length; ++i) {
                PhaseListener phaseListener = phaseListeners[i];
                PhaseId phaseId = this.getCurrentPhaseId();
                if (!this.isTargetListener(phaseListener, phaseId)) continue;
                PhaseEvent event = this.createPhaseEvent(context, phaseId, lifecycle);
                phaseListener.beforePhase(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FacesContext context) {
        this.prePhase(context);
        try {
            this.executePhase(context);
        }
        finally {
            this.postPhase(context);
        }
    }

    public final void postPhase(FacesContext context) {
        Lifecycle lifecycle = this.getLifecycle();
        PhaseListener[] phaseListeners = lifecycle.getPhaseListeners();
        if (phaseListeners != null) {
            for (int i = phaseListeners.length - 1; i >= 0; --i) {
                PhaseListener phaseListener = phaseListeners[i];
                PhaseId phaseId = this.getCurrentPhaseId();
                if (!this.isTargetListener(phaseListener, phaseId)) continue;
                PhaseEvent event = this.createPhaseEvent(context, phaseId, lifecycle);
                phaseListener.afterPhase(event);
            }
        }
    }

    protected PhaseEvent createPhaseEvent(FacesContext context, PhaseId phaseId, Lifecycle lifecycle) {
        return new PhaseEvent(context, phaseId, lifecycle);
    }

    protected void initializeChildren(FacesContext context, UIComponent component) {
        Iterator i = component.getFacetsAndChildren();
        while (i.hasNext()) {
            UIComponent child = (UIComponent)i.next();
            if (child instanceof EditableValueHolder) {
                EditableValueHolder editableValueHolder = (EditableValueHolder)((Object)child);
                editableValueHolder.setValid(true);
                editableValueHolder.setSubmittedValue(null);
                editableValueHolder.setValue(null);
                editableValueHolder.setLocalValueSet(false);
            }
            this.initializeChildren(context, child);
        }
    }

    protected boolean isTargetListener(PhaseListener listener, PhaseId phaseId) {
        int listenerOrdinal = listener.getPhaseId().getOrdinal();
        return listenerOrdinal == PhaseId.ANY_PHASE.getOrdinal() || listenerOrdinal == phaseId.getOrdinal();
    }

    protected final Lifecycle getLifecycle() {
        return LifecycleUtil.getLifecycle();
    }

    protected abstract void executePhase(FacesContext var1);

    protected abstract PhaseId getCurrentPhaseId();
}

