/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.lifecycle.impl;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.event.PhaseId;
import javax.faces.internal.scope.RedirectScope;
import org.seasar.teeda.core.lifecycle.AbstractPhase;
import org.seasar.teeda.core.util.FacesContextUtil;

public class RenderResponsePhase
extends AbstractPhase {
    public void executePhase(FacesContext context) throws FacesException {
        ViewHandler viewHandler = FacesContextUtil.getViewHandler(context);
        try {
            viewHandler.renderView(context, context.getViewRoot());
        }
        catch (IOException e) {
            throw new FacesException(e.getMessage(), e);
        }
        catch (EvaluationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw ex;
        }
        finally {
            if (RedirectScope.isRedirecting(context)) {
                RedirectScope.removeContext(context);
            }
        }
    }

    protected PhaseId getCurrentPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }
}

