/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.mock;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.mock.servlet.MockHttpServletResponse;
import org.seasar.teeda.core.context.html.HtmlResponseWriter;
import org.seasar.teeda.core.mock.MockApplicationImpl;
import org.seasar.teeda.core.mock.MockExternalContext;
import org.seasar.teeda.core.mock.MockExternalContextImpl;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.util.FactoryFinderUtil;

public class MockFacesContextImpl
extends MockFacesContext {
    private UIViewRoot viewRoot = null;
    private MockExternalContext externalContext;
    private Application application;
    private Map messages = new LinkedHashMap();
    private ResponseWriter responseWriter;
    private boolean renderResponse;
    private boolean responseComplete;

    public MockFacesContextImpl() {
        MockFacesContextImpl.setCurrentInstance(this);
    }

    public MockFacesContextImpl(MockExternalContext externalContext) {
        this.externalContext = externalContext;
        this.application = FactoryFinderUtil.getApplicationFactory().getApplication();
        MockFacesContextImpl.setCurrentInstance(this);
    }

    public MockFacesContextImpl(MockExternalContext context, Application application) {
        this.externalContext = context;
        this.application = application;
        MockFacesContextImpl.setCurrentInstance(this);
    }

    public Application getApplication() {
        if (this.application == null) {
            this.application = new MockApplicationImpl();
        }
        return this.application;
    }

    public Iterator getClientIdsWithMessages() {
        return this.messages.keySet().iterator();
    }

    public ExternalContext getExternalContext() {
        return this.getMockExternalContext();
    }

    public FacesMessage.Severity getMaximumSeverity() {
        return null;
    }

    public void removeMessages() {
        this.messages = new LinkedHashMap();
    }

    public Iterator getMessages() {
        ArrayList all = new ArrayList();
        Iterator it = this.messages.values().iterator();
        while (it.hasNext()) {
            List messages = (List)it.next();
            all.addAll(messages);
        }
        return all.iterator();
    }

    public Iterator getMessages(String clientId) {
        return this.getMessagesList(clientId).iterator();
    }

    public RenderKit getRenderKit() {
        return null;
    }

    public boolean getRenderResponse() {
        return this.renderResponse;
    }

    public boolean getResponseComplete() {
        return this.responseComplete;
    }

    public ResponseStream getResponseStream() {
        return null;
    }

    public void setResponseStream(ResponseStream responseStream) {
    }

    public ResponseWriter getResponseWriter() {
        if (this.responseWriter == null) {
            HtmlResponseWriter responseWriter = new HtmlResponseWriter();
            MockHttpServletResponse response = this.getMockExternalContext().getMockHttpServletResponse();
            try {
                responseWriter.setWriter(response.getWriter());
                this.responseWriter = responseWriter;
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        return this.responseWriter;
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
    }

    public UIViewRoot getViewRoot() {
        if (this.viewRoot == null) {
            this.viewRoot = new UIViewRoot();
            this.viewRoot.setLocale(Locale.getDefault());
        }
        return this.viewRoot;
    }

    public void setViewRoot(UIViewRoot root) {
        this.viewRoot = root;
    }

    public void addMessage(String clientId, FacesMessage message) {
        List l = this.getMessagesList(clientId);
        l.add(message);
    }

    private List getMessagesList(String clientId) {
        ArrayList l = (ArrayList)this.messages.get(clientId);
        if (l == null) {
            l = new ArrayList();
            this.messages.put(clientId, l);
        }
        return l;
    }

    public void release() {
        MockFacesContextImpl.setCurrentInstance(null);
    }

    public void renderResponse() {
        this.renderResponse = true;
    }

    public void responseComplete() {
        this.responseComplete = true;
    }

    public void setExternalContext(ExternalContext context) {
        this.setMockExternalContext((MockExternalContext)context);
    }

    public void setMockExternalContext(MockExternalContext context) {
        this.externalContext = context;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public MockExternalContext getMockExternalContext() {
        if (this.externalContext == null) {
            this.externalContext = new MockExternalContextImpl();
        }
        return this.externalContext;
    }
}

