/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.portlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.internal.FacesConfigOptions;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.teeda.core.config.faces.FacesConfigBuilder;
import org.seasar.teeda.core.config.faces.assembler.AssemblerAssembler;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.webapp.WebappConfigBuilder;
import org.seasar.teeda.core.config.webapp.element.WebappConfig;
import org.seasar.teeda.core.util.DIContainerUtil;

public class FacesPortlet
extends GenericPortlet {
    private static final Log log = LogFactory.getLog((Class)FacesPortlet.class);
    public static final String PORTLET_CONFIG = "javax.portlet.PortletConfig";
    public static final String VIEW_ID = FacesPortlet.class.getName() + ".VIEW_ID";
    public final String DEFAULT_PAGE = FacesPortlet.class.getName() + ".DEFAULT_PAGE";
    public final String DEFAULT_VIEW_PAGE = "view-page";
    public final String DEFAULT_EDIT_PAGE = "edit-page";
    public final String DEFAULT_HELP_PAGE = "help-page";
    protected static final String FACES_INIT_DONE = FacesPortlet.class.getName() + ".FACES_INIT_DONE";
    public static final String FACES_PORTLET_STATE_PREFIX = FacesPortlet.class.getName() + ".FACES_PORTLET_STATE_";
    public static final String INIT_PARAMETER = FacesPortlet.class.getName() + ".INIT";
    public static final String INIT_VIEW_PARAMETER = FacesPortlet.class.getName() + ".INIT_VIEW";
    public static final String INIT_EDIT_PARAMETER = FacesPortlet.class.getName() + ".INIT_EDIT";
    public static final String INIT_HELP_PARAMETER = FacesPortlet.class.getName() + ".INIT_HELP";
    private static final String PREVIOUS_PORTLET_MODE = FacesPortlet.class.getName() + ".PREVIOUS_PORTLET_MODE";
    private static final String CURRENT_PORTLET_MODE = FacesPortlet.class.getName() + ".CURRENT_PORTLET_MODE";
    private static final String EXCLUDED_ATTRIBUTE_LIST = FacesPortlet.class.getName() + ".EXCLUDED_ATTRIBUTE_LIST";
    private static final String REDEPLOYED_PORTLET = FacesPortlet.class.getName() + ".REDEPLOYED_PORTLET";
    public static final String REDIRECT_TO_PORTLET = FacesPortlet.class.getName() + ".REDIRECT_TO_PORTLET";
    protected FacesContextFactory facesContextFactory;
    protected Lifecycle lifecycle;
    private String defaultViewPage = null;
    private String defaultEditPage = null;
    private String defaultHelpPage = null;

    public void init() throws PortletException {
        super.init();
        this.initializeFaces(this.getPortletContext());
        this.defaultViewPage = this.getPortletConfig().getInitParameter("view-page");
        this.defaultEditPage = this.getPortletConfig().getInitParameter("edit-page");
        this.defaultHelpPage = this.getPortletConfig().getInitParameter("help-page");
        if (null == this.defaultViewPage) {
            throw new PortletException("Portlet " + this.getPortletConfig().getPortletName() + " is incorrectly configured. No default View page is defined.");
        }
        if (null == this.defaultEditPage) {
            this.defaultEditPage = this.defaultViewPage;
        }
        if (null == this.defaultHelpPage) {
            this.defaultHelpPage = this.defaultViewPage;
        }
        this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory("javax.faces.context.FacesContextFactory");
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
        this.lifecycle = lifecycleFactory.getLifecycle(FacesConfigOptions.getLifecycleId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeFaces(PortletContext servletContext) {
        boolean isAlreadyInitialized;
        Boolean b = (Boolean)servletContext.getAttribute(FACES_INIT_DONE);
        boolean bl = isAlreadyInitialized = b != null ? b : false;
        if (!isAlreadyInitialized) {
            this.initializeFacesConfigOptions(servletContext);
            FacesConfigBuilder facesConfigBuilder = (FacesConfigBuilder)DIContainerUtil.getComponent(FacesConfigBuilder.class);
            FacesConfig facesConfig = facesConfigBuilder.buildFacesConfigs();
            AssemblerAssembler assembler = (AssemblerAssembler)DIContainerUtil.getComponent(AssemblerAssembler.class);
            assembler.assembleFactories(facesConfig);
            assembler.assembleApplication(facesConfig);
            assembler.assembleManagedBeans(facesConfig);
            assembler.assmbleNavigationRules(facesConfig);
            assembler.assembleLifecycle(facesConfig);
            assembler.assembleRenderKits(facesConfig);
            WebappConfigBuilder webAppConfigBuilder = (WebappConfigBuilder)DIContainerUtil.getComponent(WebappConfigBuilder.class);
            InputStream is = null;
            WebappConfig webappConfig = null;
            try {
                is = servletContext.getResourceAsStream("/WEB-INF/web.xml");
                webappConfig = webAppConfigBuilder.build(is, "/WEB-INF/web.xml");
            }
            finally {
                InputStreamUtil.close((InputStream)is);
            }
            servletContext.setAttribute(WebappConfig.class.getName(), (Object)webappConfig);
            servletContext.setAttribute(FACES_INIT_DONE, (Object)Boolean.TRUE);
        }
    }

    protected void initializeFacesConfigOptions(PortletContext servletContext) {
        String suffix;
        FacesConfigOptions.setConfigFiles(servletContext.getInitParameter("javax.faces.CONFIG_FILES"));
        String savingMethod = servletContext.getInitParameter("javax.faces.STATE_SAVING_METHOD");
        if (savingMethod != null) {
            FacesConfigOptions.setSavingStateInClient("client".equalsIgnoreCase(savingMethod));
        }
        if ((suffix = servletContext.getInitParameter("javax.faces.DEFAULT_SUFFIX")) != null) {
            FacesConfigOptions.setDefaultSuffix(suffix);
        } else {
            FacesConfigOptions.setDefaultSuffix(".jsp");
        }
        String lifecycleId = servletContext.getInitParameter("javax.faces.LIFECYCLE_ID");
        if (lifecycleId != null) {
            FacesConfigOptions.setLifecycleId(lifecycleId);
        } else {
            FacesConfigOptions.setLifecycleId("DEFAULT");
        }
    }

    public void destroy() {
        super.destroy();
        FactoryFinder.releaseFactories();
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.setContentType(request, response);
        this.setDefaultPage((PortletRequest)request, this.defaultEditPage);
        this.renderFaces(request, response);
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.setContentType(request, response);
        this.setDefaultPage((PortletRequest)request, this.defaultHelpPage);
        this.renderFaces(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.setContentType(request, response);
        this.setDefaultPage((PortletRequest)request, this.defaultViewPage);
        this.renderFaces(request, response);
    }

    protected void setContentType(RenderRequest request, RenderResponse response) {
        if (response.getContentType() == null) {
            String portalPreferredContentType = request.getResponseContentType();
            if (portalPreferredContentType != null) {
                response.setContentType(portalPreferredContentType);
            } else {
                response.setContentType("text/html");
            }
        }
    }

    protected void storePortletConfig(PortletRequest request) {
        request.setAttribute(PORTLET_CONFIG, (Object)this.getPortletConfig());
    }

    protected void setDefaultPage(PortletRequest request, String page) {
        request.setAttribute(this.DEFAULT_PAGE, (Object)page);
    }

    protected void setCurrentPortletMode(PortletRequest request) {
        request.setAttribute(CURRENT_PORTLET_MODE, (Object)request.getPortletMode().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void renderFaces(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"called renderFaces..");
        }
        this.storePortletConfig((PortletRequest)request);
        this.setCurrentPortletMode((PortletRequest)request);
        FacesContext facesContext = this.facesContextFactory.getFacesContext(this.getPortletContext(), request, response, this.lifecycle);
        this.restoreFacesState(facesContext);
        try {
            try {
                this.lifecycle.render(facesContext);
            }
            catch (Throwable e) {
                this.handleException(e);
                Object var6_5 = null;
                facesContext.release();
                request.getPortletSession().setAttribute(PREVIOUS_PORTLET_MODE, (Object)request.getPortletMode().toString());
                request.getPortletSession().setAttribute(REDEPLOYED_PORTLET, (Object)Boolean.FALSE);
                return;
            }
            Object var6_4 = null;
            facesContext.release();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            facesContext.release();
            request.getPortletSession().setAttribute(PREVIOUS_PORTLET_MODE, (Object)request.getPortletMode().toString());
            request.getPortletSession().setAttribute(REDEPLOYED_PORTLET, (Object)Boolean.FALSE);
            throw throwable;
        }
        request.getPortletSession().setAttribute(PREVIOUS_PORTLET_MODE, (Object)request.getPortletMode().toString());
        request.getPortletSession().setAttribute(REDEPLOYED_PORTLET, (Object)Boolean.FALSE);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"called processAction..");
        }
        if (this.checkTimeOut((PortletRequest)request)) {
            return;
        }
        this.executeFaces(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeFaces(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        this.storePortletConfig((PortletRequest)request);
        this.setCurrentPortletMode((PortletRequest)request);
        ArrayList excludedNameList = new ArrayList();
        Enumeration enu = request.getAttributeNames();
        while (enu.hasMoreElements()) {
            excludedNameList.add(enu.nextElement());
        }
        excludedNameList.add(EXCLUDED_ATTRIBUTE_LIST);
        excludedNameList.add("facesContext");
        request.setAttribute(EXCLUDED_ATTRIBUTE_LIST, excludedNameList);
        FacesContext facesContext = this.facesContextFactory.getFacesContext(this.getPortletContext(), request, response, this.lifecycle);
        try {
            this.lifecycle.execute(facesContext);
            if (!facesContext.getResponseComplete()) {
                request.setAttribute(VIEW_ID, (Object)facesContext.getViewRoot().getViewId());
                this.saveFacesState(facesContext);
            }
        }
        catch (Throwable e) {
            this.handleException(e);
        }
        finally {
            facesContext.release();
        }
    }

    protected void handleException(Throwable e) throws PortletException, IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof PortletException) {
            throw (PortletException)e;
        }
        if (e.getMessage() != null) {
            throw new PortletException(e.getMessage(), e);
        }
        throw new PortletException(e);
    }

    protected boolean checkTimeOut(PortletRequest request) {
        return request.getPortletSession(false) == null;
    }

    protected boolean checkTimedOut(FacesContext context) {
        return context.getExternalContext().getSession(false) == null;
    }

    protected boolean checkSessionState(PortletRequest request) {
        return this.checkTimeOut(request) || request.getPortletSession().getAttribute(REDEPLOYED_PORTLET) == null;
    }

    protected boolean checkSessionState(FacesContext context) {
        return this.checkTimedOut(context) || context.getExternalContext().getSessionMap().get(REDEPLOYED_PORTLET) == null;
    }

    protected void restoreFacesState(FacesContext facesContext) {
        PortletSession session = (PortletSession)facesContext.getExternalContext().getSession(true);
        String currentPortletMode = (String)facesContext.getExternalContext().getRequestMap().get(CURRENT_PORTLET_MODE);
        String previousPortletMode = (String)session.getAttribute(PREVIOUS_PORTLET_MODE);
        FacesPortletState state = null;
        if (previousPortletMode != null && previousPortletMode.equals(currentPortletMode)) {
            state = (FacesPortletState)session.getAttribute(FACES_PORTLET_STATE_PREFIX + currentPortletMode);
        } else {
            facesContext.getExternalContext().getRequestMap().put(VIEW_ID, facesContext.getExternalContext().getRequestMap().get(this.DEFAULT_PAGE));
            Iterator i = facesContext.getExternalContext().getSessionMap().entrySet().iterator();
            while (i.hasNext()) {
                String key;
                Map.Entry e = i.next();
                if (!(e.getKey() instanceof String) || !(key = (String)e.getKey()).startsWith(FACES_PORTLET_STATE_PREFIX)) continue;
                facesContext.getExternalContext().getSessionMap().remove(key);
            }
        }
        if (state == null) {
            this.setViewId(facesContext);
            return;
        }
        facesContext.getExternalContext().getRequestMap().put(VIEW_ID, state.getViewRoot().getViewId());
        Object redirectToPortlet = state.getRequestMap().get(REDIRECT_TO_PORTLET);
        if (redirectToPortlet != null) {
            this.setViewId(facesContext);
            return;
        }
        Iterator clientIds = state.getClientIds();
        while (clientIds.hasNext()) {
            String clientId = (String)clientIds.next();
            Iterator msgs = state.getMessages(clientId);
            while (msgs.hasNext()) {
                facesContext.addMessage(clientId, (FacesMessage)msgs.next());
            }
        }
        facesContext.setViewRoot(state.getViewRoot());
        this.copyMap(state.getRequestMap(), facesContext.getExternalContext().getRequestMap(), new ArrayList());
    }

    private void saveFacesState(FacesContext facesContext) {
        PortletSession session = (PortletSession)facesContext.getExternalContext().getSession(true);
        String currentPortletMode = (String)facesContext.getExternalContext().getRequestMap().get(CURRENT_PORTLET_MODE);
        session.setAttribute(PREVIOUS_PORTLET_MODE, (Object)currentPortletMode);
        Object redirectToPortlet = facesContext.getExternalContext().getRequestMap().get(REDIRECT_TO_PORTLET);
        FacesPortletState state = new FacesPortletState();
        state.setViewRoot(facesContext.getViewRoot());
        if (redirectToPortlet == null) {
            Iterator clientIds = facesContext.getClientIdsWithMessages();
            while (clientIds.hasNext()) {
                String clientId = (String)clientIds.next();
                Iterator msgs = facesContext.getMessages(clientId);
                while (msgs.hasNext()) {
                    state.addMessage(clientId, (FacesMessage)msgs.next());
                }
            }
            List excludedNameList = (List)facesContext.getExternalContext().getRequestMap().get(EXCLUDED_ATTRIBUTE_LIST);
            HashMap requestMap = new HashMap();
            this.copyMap(facesContext.getExternalContext().getRequestMap(), requestMap, excludedNameList);
            state.setRequestMap(requestMap);
        } else {
            HashMap requestMap = new HashMap();
            requestMap.put(REDIRECT_TO_PORTLET, redirectToPortlet);
            state.setRequestMap(requestMap);
        }
        session.setAttribute(FACES_PORTLET_STATE_PREFIX + currentPortletMode, (Object)state);
    }

    private void copyMap(Map fromMap, Map toMap, List excludedNameList) {
        Iterator i = fromMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (toMap.containsKey((String)e.getKey()) || excludedNameList.contains((String)e.getKey())) continue;
            toMap.put(e.getKey(), e.getValue());
        }
    }

    private String getCurrentViewId(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String viewId = (String)requestParameterMap.get(VIEW_ID);
        if (viewId != null && !this.checkSessionState(facesContext)) {
            return viewId;
        }
        viewId = (String)requestMap.get(VIEW_ID);
        if (viewId != null && !this.checkSessionState(facesContext)) {
            return viewId;
        }
        return (String)requestMap.get(this.DEFAULT_PAGE);
    }

    private void setViewId(FacesContext facesContext) {
        String viewId = this.getCurrentViewId(facesContext);
        facesContext.getApplication().getViewHandler().restoreView(facesContext, viewId);
        if (facesContext.getViewRoot() == null) {
            facesContext.setViewRoot(facesContext.getApplication().getViewHandler().createView(facesContext, viewId));
            facesContext.getExternalContext().getRequestMap().put(VIEW_ID, viewId);
        } else {
            facesContext.getViewRoot().setViewId(viewId);
        }
    }

    private class FacesPortletState {
        private Map messages = new HashMap();
        private Map requestMap = null;
        private UIViewRoot viewRoot;

        private FacesPortletState() {
        }

        public void addMessage(String clientId, FacesMessage message) {
            ArrayList<FacesMessage> list = (ArrayList<FacesMessage>)this.messages.get(clientId);
            if (list == null) {
                list = new ArrayList<FacesMessage>();
                this.messages.put(clientId, list);
            }
            list.add(message);
        }

        public Iterator getMessages(String clientId) {
            List list = (List)this.messages.get(clientId);
            if (list != null) {
                return list.iterator();
            }
            return Collections.EMPTY_LIST.iterator();
        }

        public StringBuffer getMessagesBuffer(String clientId) {
            List list = (List)this.messages.get(clientId);
            StringBuffer buffer = new StringBuffer();
            if (list != null) {
                Iterator messages = list.iterator();
                while (messages.hasNext()) {
                    FacesMessage message = (FacesMessage)messages.next();
                    buffer.append(" ");
                    buffer.append(message.getDetail());
                }
            }
            return buffer;
        }

        public Iterator getClientIds() {
            return this.messages.keySet().iterator();
        }

        public UIViewRoot getViewRoot() {
            return this.viewRoot;
        }

        public void setViewRoot(UIViewRoot viewRoot) {
            this.viewRoot = viewRoot;
        }

        public Map getRequestMap() {
            return this.requestMap;
        }

        public void setRequestMap(Map requestMap) {
            this.requestMap = requestMap;
        }
    }
}

