/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.internal.IgnoreAttribute;
import javax.faces.internal.UIComponentUtil;
import javax.faces.render.Renderer;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.ModifierUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.ComponentIdLookupStrategy;
import org.seasar.teeda.core.render.DefaultComponentIdLookupStrategy;
import org.seasar.teeda.core.util.LoopIterator;
import org.seasar.teeda.core.util.RenderedComponentIterator;
import org.seasar.teeda.core.util.RendererUtil;

public abstract class AbstractRenderer
extends Renderer {
    private ComponentIdLookupStrategy idLookupStartegy = new DefaultComponentIdLookupStrategy();

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        this.assertNotNull(context, component);
        return RendererUtil.getConvertedUIOutputValue(context, (UIOutput)component, submittedValue);
    }

    protected String getIdForRender(FacesContext context, UIComponent component) {
        return this.idLookupStartegy.getId(context, component);
    }

    protected UIComponent toNullIfNotRendered(UIComponent component) {
        if (component != null && !component.isRendered()) {
            return null;
        }
        return component;
    }

    protected void encodeComponent(FacesContext context, UIComponent component) throws IOException {
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            this.encodeDescendantComponent(context, component);
        }
        component.encodeEnd(context);
    }

    protected void encodeDescendantComponent(FacesContext context, UIComponent component) throws IOException {
        Iterator it = this.getRenderedChildrenIterator(component);
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            this.encodeComponent(context, child);
        }
    }

    protected void assertNotNull(FacesContext context, UIComponent component) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
    }

    protected String[] splitByComma(String s) {
        String[] split = StringUtil.split((String)s, (String)",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim();
        }
        return split;
    }

    protected LoopIterator toStyleLoopIterator(String s) {
        return new LoopIterator(this.splitByComma(s));
    }

    protected Iterator getRenderedChildrenIterator(UIComponent component) {
        return new RenderedComponentIterator(component.getChildren());
    }

    protected String getLabelStyleClass(UIComponent component, boolean disabled) {
        if (disabled) {
            return UIComponentUtil.getStringAttribute(component, "disabledClass");
        }
        return UIComponentUtil.getStringAttribute(component, "enabledClass");
    }

    protected void renderRemainAttributes(UIComponent component, ResponseWriter writer, IgnoreAttribute ignore) throws IOException {
        Map map = this.getAllAttributesAndProperties(component, ignore);
        this.renderAttributes(map, writer);
    }

    protected void renderAttributes(Map attributes, ResponseWriter writer) throws IOException {
        Iterator it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            if (!this.isRenderAttributeName(key)) continue;
            RendererUtil.renderAttribute(writer, key, entry.getValue());
        }
    }

    protected Map getAllAttributesAndProperties(UIComponent component, IgnoreAttribute ignore) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(component.getClass());
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc propertyDesc = beanDesc.getPropertyDesc(i);
            Method m = propertyDesc.getReadMethod();
            if (!propertyDesc.hasReadMethod() || !this.isPublicNoParameterMethod(m) || ArrayUtil.contains((Object[])ignore.getAttributeNames(), (Object)propertyDesc.getPropertyName())) continue;
            map.put(propertyDesc.getPropertyName(), propertyDesc.getValue((Object)component));
        }
        Iterator itr = component.getAttributes().entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            String name = (String)entry.getKey();
            if (!this.isRenderAttributeName(name) || ArrayUtil.contains((Object[])ignore.getAttributeNames(), (Object)name)) continue;
            map.put(name, entry.getValue());
        }
        return map;
    }

    protected boolean isRenderAttributeName(String key) {
        return -1 == key.indexOf(46);
    }

    private boolean isPublicNoParameterMethod(Method m) {
        return ModifierUtil.isPublic((Method)m) && m.getParameterTypes().length == 0;
    }

    public void setComponentIdLookupStrategy(ComponentIdLookupStrategy idLookupStartegy) {
        this.idLookupStartegy = idLookupStartegy;
    }

    public ComponentIdLookupStrategy getComponentIdLookupStrategy() {
        return this.idLookupStartegy;
    }

    protected boolean containsAttributeForRender(UIComponent component, IgnoreAttribute ignore) {
        if (RendererUtil.shouldRenderIdAttribute(component)) {
            return true;
        }
        Map map = this.getAllAttributesAndProperties(component, ignore);
        Set keys = map.keySet();
        String[] names = new String[keys.size()];
        keys.toArray(names);
        if (RendererUtil.containsAttributesForRender(component, names)) {
            return true;
        }
        return this.containsAttributeForRender(component.getAttributes());
    }

    protected boolean containsAttributeForRender(Map attributes) {
        Iterator it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Object value;
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            if (!this.isRenderAttributeName(key) || !RendererUtil.shouldRenderAttribute(key, value = entry.getValue())) continue;
            return true;
        }
        return false;
    }

    protected void renderCheckedAttribute(ResponseWriter writer) throws IOException {
        RendererUtil.renderAttribute(writer, "checked", (Object)"checked");
    }

    protected void renderDisabledAttribute(ResponseWriter writer) throws IOException {
        RendererUtil.renderAttribute(writer, "disabled", (Object)"disabled");
    }

    protected void renderSelectedAttribute(ResponseWriter writer) throws IOException {
        RendererUtil.renderAttribute(writer, "selected", (Object)"selected");
    }

    protected void renderJavaScriptElement(ResponseWriter writer, String scriptBody) throws IOException {
        if (StringUtil.isBlank((String)scriptBody)) {
            return;
        }
        writer.write("\n");
        writer.startElement("script", null);
        writer.writeAttribute("language", "JavaScript", null);
        writer.writeAttribute("type", "text/javascript", null);
        writer.write("\n");
        writer.write("<!--");
        writer.write("\n");
        writer.write(scriptBody);
        writer.write("\n");
        writer.write("//-->");
        writer.write("\n");
        writer.endElement("script");
    }

    protected void renderIncludeJavaScript(ResponseWriter writer, String path) throws IOException {
        if (StringUtil.isBlank((String)path)) {
            return;
        }
        writer.startElement("script", null);
        writer.writeAttribute("language", "JavaScript", null);
        writer.writeAttribute("type", "text/javascript", null);
        writer.writeAttribute("src", path, null);
        writer.endElement("script");
    }

    protected void renderStyleSheet(ResponseWriter writer, String path) throws IOException {
        if (StringUtil.isBlank((String)path)) {
            return;
        }
        writer.startElement("link", null);
        writer.writeAttribute("type", "text/css", null);
        writer.writeAttribute("rel", "stylesheet", null);
        writer.writeAttribute("href", path, null);
        writer.endElement("link");
    }
}

