/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render;

import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.exception.NoEditableValueHolderRuntimeException;
import org.seasar.teeda.core.render.Decoder;

public class DefaultDecoder
implements Decoder {
    public void decode(FacesContext context, UIComponent component) {
        AssertionUtil.assertNotNull((String)"context is null.", (Object)context);
        AssertionUtil.assertNotNull((String)"component is null.", (Object)component);
        EditableValueHolder evh = this.getEditableHolder(component);
        Map paramMap = this.getRequestParameterMap(context);
        String clientId = this.getClientId(component, context);
        if (paramMap.containsKey(clientId)) {
            Object submittedValue = paramMap.get(clientId);
            evh.setSubmittedValue(submittedValue);
        }
    }

    public void decodeMany(FacesContext context, UIComponent component) {
        AssertionUtil.assertNotNull((String)"context is null.", (Object)context);
        AssertionUtil.assertNotNull((String)"component is null.", (Object)component);
        EditableValueHolder evh = this.getEditableHolder(component);
        Map paramValuesMap = this.getRequestParameterValuesMap(context);
        String clientId = this.getClientId(component, context);
        String[] value = null;
        if (paramValuesMap.containsKey(clientId)) {
            value = (String[])paramValuesMap.get(clientId);
        }
        if (value != null) {
            evh.setSubmittedValue(value);
        } else {
            evh.setSubmittedValue(new String[0]);
        }
    }

    protected Map getRequestParameterMap(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap();
    }

    protected Map getRequestParameterValuesMap(FacesContext context) {
        return context.getExternalContext().getRequestParameterValuesMap();
    }

    protected String getClientId(UIComponent component, FacesContext context) {
        return component.getClientId(context);
    }

    protected EditableValueHolder getEditableHolder(UIComponent component) {
        AssertionUtil.assertNotNull((String)"component is null.", (Object)component);
        if (!(component instanceof EditableValueHolder)) {
            throw new NoEditableValueHolderRuntimeException(component.getClass());
        }
        return (EditableValueHolder)((Object)component);
    }
}

