/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.internal.IgnoreAttribute;
import javax.faces.internal.UIComponentUtil;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.render.html.HtmlFormRenderer;
import org.seasar.teeda.core.util.ExternalContextUtil;
import org.seasar.teeda.core.util.FacesContextUtil;
import org.seasar.teeda.core.util.HtmlFormRendererUtil;
import org.seasar.teeda.core.util.JavaScriptPermissionUtil;
import org.seasar.teeda.core.util.JavaScriptUtil;
import org.seasar.teeda.core.util.RendererUtil;

public class HtmlCommandLinkRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Command";
    public static final String RENDERER_TYPE = "javax.faces.Link";
    private static final String HIDDEN_FIELD_NAME_SUFFIX = "__link_clicked__";
    private final IgnoreAttribute ignoreComponent = new IgnoreAttribute();

    public HtmlCommandLinkRenderer() {
        this.ignoreComponent.addAttributeName("id");
        this.ignoreComponent.addAttributeName("value");
        this.ignoreComponent.addAttributeName("onclick");
        this.ignoreComponent.addAttributeName("action");
        this.ignoreComponent.addAttributeName("immediate");
        this.ignoreComponent.addAttributeName("href");
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlCommandLinkBegin(context, (HtmlCommandLink)component);
    }

    protected void encodeHtmlCommandLinkBegin(FacesContext context, HtmlCommandLink commandLink) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", commandLink);
        RendererUtil.renderIdAttributeIfNecessary(writer, commandLink, this.getIdForRender(context, commandLink));
        if (JavaScriptPermissionUtil.isJavaScriptPermitted(context)) {
            this.encodeHtmlCommandLinkWithJavaScript(context, writer, commandLink);
        } else {
            this.encodeHtmlCommandLinkWithoutJavaScript(context, writer, commandLink);
        }
    }

    protected void encodeHtmlCommandLinkWithJavaScript(FacesContext context, ResponseWriter writer, HtmlCommandLink commandLink) throws IOException {
        UIForm parentForm = UIComponentUtil.findParentForm(commandLink);
        String formId = this.getIdForRender(context, parentForm);
        RendererUtil.renderAttribute(writer, "href", (Object)"#");
        StringBuffer sb = new StringBuffer(320);
        String onclick = commandLink.getOnclick();
        if (onclick != null) {
            sb.append(onclick);
            if (!onclick.endsWith(";")) {
                sb.append(";");
            }
        }
        String formName = parentForm.getClientId(context);
        String functionName = JavaScriptUtil.getClearHiddenCommandFormParamsFunctionName(formName) + "();";
        sb.append(functionName);
        sb.append("var f = document.forms['");
        sb.append(formId);
        sb.append("'];");
        sb.append(" f['");
        String hiddenFieldName = this.getHiddenFieldName(formId);
        sb.append(hiddenFieldName);
        sb.append("'].value = '");
        sb.append(commandLink.getClientId(context));
        sb.append("';");
        HtmlFormRenderer.setHiddenParameter(parentForm, hiddenFieldName, null);
        Iterator it = commandLink.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (!(child instanceof UIParameter)) continue;
            UIParameter p = (UIParameter)child;
            String name = p.getName();
            Object value = p.getValue();
            sb.append(" f['" + name + "'].value = '");
            sb.append(String.valueOf(value));
            sb.append("';");
            HtmlFormRenderer.setHiddenParameter(parentForm, name, null);
        }
        String target = commandLink.getTarget();
        if (target != null && target.trim().length() > 0) {
            sb.append(" f.target = '");
            sb.append(target);
            sb.append("';");
        }
        sb.append(" if (f.onsubmit) { f.onsubmit(); }");
        sb.append(" f.submit();");
        sb.append(functionName);
        sb.append(" return false;");
        RendererUtil.renderAttribute(writer, "onclick", (Object)sb.toString());
        this.renderRemainAttributes(commandLink, writer, this.ignoreComponent);
        Object value = commandLink.getValue();
        if (value != null) {
            writer.writeText(value.toString(), "value");
        }
    }

    protected void encodeHtmlCommandLinkWithoutJavaScript(FacesContext context, ResponseWriter writer, HtmlCommandLink commandLink) throws IOException {
        ViewHandler viewHandler = FacesContextUtil.getViewHandler(context);
        String viewId = context.getViewRoot().getViewId();
        String path = viewHandler.getActionURL(context, viewId);
        StringBuffer hrefBuf = new StringBuffer(100);
        hrefBuf.append(path);
        if (path.indexOf("?") == -1) {
            hrefBuf.append("?");
        } else {
            hrefBuf.append("&");
        }
        UIForm parentForm = UIComponentUtil.findParentForm(commandLink);
        String formSubmitKey = HtmlFormRendererUtil.getFormSubmitKey(context, parentForm);
        hrefBuf.append(formSubmitKey);
        hrefBuf.append("=");
        hrefBuf.append(formSubmitKey);
        hrefBuf.append("&");
        String formId = this.getIdForRender(context, parentForm);
        String hiddenFieldName = this.getHiddenFieldName(formId);
        hrefBuf.append(hiddenFieldName);
        hrefBuf.append("=");
        hrefBuf.append(commandLink.getClientId(context));
        if (commandLink.getChildCount() > 0) {
            this.addChildParametersToHref(commandLink, hrefBuf, writer.getCharacterEncoding());
        }
        String href = ExternalContextUtil.encodeActionURL(context, hrefBuf.toString());
        writer.writeURIAttribute("href", href, null);
        Object value = commandLink.getValue();
        if (value != null) {
            writer.writeText(value.toString(), "value");
        }
    }

    private void addChildParametersToHref(UIComponent linkComponent, StringBuffer hrefBuf, String charEncoding) throws IOException {
        Iterator it = linkComponent.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            String name = param.getName();
            Object value = param.getValue();
            HtmlCommandLinkRenderer.addParameterToHref(name, value, hrefBuf, charEncoding);
        }
    }

    private static void addParameterToHref(String name, Object value, StringBuffer hrefBuf, String charEncoding) throws UnsupportedEncodingException {
        if (name == null) {
            throw new IllegalArgumentException("Unnamed parameter value not allowed within command link.");
        }
        hrefBuf.append("&");
        hrefBuf.append(URLEncoder.encode(name, charEncoding));
        hrefBuf.append("=");
        if (value != null) {
            hrefBuf.append(URLEncoder.encode(value.toString(), charEncoding));
        }
    }

    private String getHiddenFieldName(String formId) {
        return formId + ':' + HIDDEN_FIELD_NAME_SUFFIX;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlCommandLinkEnd(context, (HtmlCommandLink)component);
    }

    protected void encodeHtmlCommandLinkEnd(FacesContext context, HtmlCommandLink commandLink) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("a");
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        this.decodeHtmlCommandLink(context, (HtmlCommandLink)component);
    }

    protected void decodeHtmlCommandLink(FacesContext context, HtmlCommandLink commandLink) {
        UIForm parentForm;
        String formId;
        String hiddenFieldName;
        String entry;
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String clientId = commandLink.getClientId(context);
        if (clientId.equals(entry = (String)paramMap.get(hiddenFieldName = this.getHiddenFieldName(formId = this.getIdForRender(context, parentForm = UIComponentUtil.findParentForm(commandLink)))))) {
            commandLink.queueEvent(new ActionEvent(commandLink));
        }
    }

    public boolean getRendersChildren() {
        return true;
    }
}

