/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.util.FacesContextUtil;
import org.seasar.teeda.core.util.RendererUtil;

public class HtmlGraphicImageRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Graphic";
    public static final String RENDERER_TYPE = "javax.faces.Image";
    private final IgnoreAttribute ignoreComponent = new IgnoreAttribute();

    public HtmlGraphicImageRenderer() {
        this.ignoreComponent.addAttributeName("id");
        this.ignoreComponent.addAttributeName("value");
        this.ignoreComponent.addAttributeName("url");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlGraphicImageEnd(context, (HtmlGraphicImage)component);
    }

    protected void encodeHtmlGraphicImageEnd(FacesContext context, HtmlGraphicImage htmlGraphicImage) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("img", htmlGraphicImage);
        RendererUtil.renderIdAttributeIfNecessary(writer, htmlGraphicImage, this.getIdForRender(context, htmlGraphicImage));
        String url = this.getUrl(context, htmlGraphicImage);
        writer.writeURIAttribute("src", url, null);
        this.renderRemainAttributes(htmlGraphicImage, writer, this.ignoreComponent);
        writer.endElement("img");
    }

    protected String getUrl(FacesContext context, HtmlGraphicImage htmlGraphicImage) {
        String url = htmlGraphicImage.getUrl();
        if (url == null) {
            url = "";
        }
        url = FacesContextUtil.getViewHandler(context).getResourceURL(context, url);
        url = context.getExternalContext().encodeResourceURL(url);
        return url;
    }
}

