/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import org.seasar.teeda.core.render.AbstractInputRenderer;
import org.seasar.teeda.core.util.HTMLEncodeUtil;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;

public class HtmlInputTextRenderer
extends AbstractInputRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    public static final String RENDERER_TYPE = "javax.faces.Text";
    private final IgnoreAttribute ignoreComponent = new IgnoreAttribute();

    public HtmlInputTextRenderer() {
        this.ignoreComponent.addAttributeName("id");
        this.ignoreComponent.addAttributeName("name");
        this.ignoreComponent.addAttributeName("type");
        this.ignoreComponent.addAttributeName("value");
        this.ignoreComponent.addAttributeName("styleClass");
        this.ignoreComponent.addAttributeName("autocomplete");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlInputTextEnd(context, (HtmlInputText)component);
    }

    protected void encodeHtmlInputTextEnd(FacesContext context, HtmlInputText htmlInputText) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", htmlInputText);
        RendererUtil.renderAttribute(writer, "type", (Object)"text");
        RendererUtil.renderIdAttributeIfNecessary(writer, htmlInputText, this.getIdForRender(context, htmlInputText));
        RendererUtil.renderAttribute(writer, "name", (Object)htmlInputText.getClientId(context));
        String value = ValueHolderUtil.getValueForRender(context, htmlInputText);
        RendererUtil.renderAttribute(writer, "value", (Object)HTMLEncodeUtil.encode(value, true, true));
        RendererUtil.renderAttribute(writer, "autocomplete", (Object)htmlInputText.getAutocomplete());
        this.renderStyleClass(context, htmlInputText, writer);
        this.renderRemainAttributes(htmlInputText, writer, this.ignoreComponent);
        writer.endElement("input");
    }

    protected void renderStyleClass(FacesContext context, HtmlInputText htmlInputText, ResponseWriter writer) throws IOException {
        String styleClass = htmlInputText.getStyleClass();
        RendererUtil.renderAttribute(writer, "styleClass", (Object)styleClass);
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        this.decodeHtmlInputText(context, (HtmlInputText)component);
    }

    protected void decodeHtmlInputText(FacesContext context, HtmlInputText htmlInputText) {
        this.getDecoder().decode(context, htmlInputText);
    }

    public void addIgnoreAttributeName(String name) {
        this.ignoreComponent.addAttributeName(name);
    }
}

