/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.internal.IgnoreAttribute;
import javax.faces.internal.SelectItemsIterator;
import javax.faces.internal.UIComponentUtil;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.seasar.framework.util.ArrayIterator;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.teeda.core.render.AbstractInputRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;

public class HtmlSelectManyListboxRenderer
extends AbstractInputRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.SelectMany";
    public static final String RENDERER_TYPE = "javax.faces.Listbox";
    private final IgnoreAttribute ignoreComponent = new IgnoreAttribute();

    public HtmlSelectManyListboxRenderer() {
        this.ignoreComponent.addAttributeName("id");
        this.ignoreComponent.addAttributeName("value");
        this.ignoreComponent.addAttributeName("size");
        this.ignoreComponent.addAttributeName("selectedValues");
        this.ignoreComponent.addAttributeName("disabledClass");
        this.ignoreComponent.addAttributeName("enabledClass");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlSelectListboxEnd(context, component);
    }

    protected void encodeHtmlSelectListboxEnd(FacesContext context, UIComponent component) throws IOException {
        SelectItemsIterator it = new SelectItemsIterator(component);
        if (!it.hasNext()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("select", component);
        RendererUtil.renderIdAttributeIfNecessary(writer, component, this.getIdForRender(context, component));
        RendererUtil.renderAttribute(writer, "name", (Object)component.getClientId(context));
        this.renderMultiple(context, component, writer);
        this.renderSize(context, component, writer);
        this.renderRemainAttributes(component, writer, this.ignoreComponent);
        String[] selectedValues = this.getValuesForRender(context, component);
        this.renderSelectItems(context, component, writer, it, selectedValues);
        writer.endElement("select");
    }

    protected String[] getValuesForRender(FacesContext context, UIComponent component) {
        return ValueHolderUtil.getValuesForRender(context, component);
    }

    protected void renderSize(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        int size = this.getSize(component);
        RendererUtil.renderAttribute(writer, "size", new Integer(size));
    }

    private int getSize(UIComponent component) {
        int size = UIComponentUtil.getPrimitiveIntAttribute(component, "size");
        if (0 < size) {
            return size;
        }
        size = 0;
        SelectItemsIterator it = new SelectItemsIterator(component);
        while (it.hasNext()) {
            SelectItem item = (SelectItem)it.next();
            if (item instanceof SelectItemGroup) {
                SelectItemGroup itemGroup = (SelectItemGroup)item;
                size += itemGroup.getSelectItems().length;
            }
            ++size;
        }
        return size;
    }

    protected void renderMultiple(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        RendererUtil.renderAttribute(writer, "multiple", (Object)"multiple");
    }

    protected void renderSelectItems(FacesContext context, UIComponent component, ResponseWriter writer, Iterator it, String[] selectedValues) throws IOException {
        while (it.hasNext()) {
            SelectItem selectItem = (SelectItem)it.next();
            if (selectItem instanceof SelectItemGroup) {
                SelectItemGroup selectItemGroup = (SelectItemGroup)selectItem;
                Object[] selectItems = selectItemGroup.getSelectItems();
                ArrayIterator selectItemsIt = new ArrayIterator(selectItems);
                writer.startElement("optgroup", component);
                RendererUtil.renderAttribute(writer, "label", (Object)selectItemGroup.getLabel());
                this.renderSelectItems(context, component, writer, (Iterator)selectItemsIt, selectedValues);
                writer.endElement("optgroup");
                continue;
            }
            writer.startElement("option", component);
            Object value = selectItem.getValue();
            RendererUtil.renderAttribute(writer, "value", value);
            boolean disabled = UIComponentUtil.isDisabled(component) || selectItem.isDisabled();
            String labelClass = this.getLabelStyleClass(component, disabled);
            if (labelClass != null) {
                RendererUtil.renderAttribute(writer, "class", (Object)labelClass);
            }
            if (value != null && this.isSelected(selectedValues, value.toString())) {
                this.renderSelectedAttribute(writer);
            }
            if (selectItem.isDisabled()) {
                this.renderDisabledAttribute(writer);
            }
            writer.writeText(selectItem.getLabel(), null);
            writer.endElement("option");
        }
    }

    private boolean isSelected(String[] selectedValues, String value) {
        return ArrayUtil.contains((Object[])selectedValues, (Object)value);
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        this.getDecoder().decodeMany(context, component);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        this.assertNotNull(context, component);
        return RendererUtil.getConvertedUIOutputValues(context, (UIOutput)component, submittedValue);
    }

    public void addIgnoreAttributeName(String name) {
        this.ignoreComponent.addAttributeName(name);
    }
}

