/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.application.NavigationHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.internal.scope.RedirectScope;
import org.seasar.teeda.core.exception.AlreadyRedirectingException;

public class NavigationHandlerUtil {
    private NavigationHandlerUtil() {
    }

    public static void handleNavigation(FacesContext context, String fromAction, String outCome) {
        NavigationHandler handler = context.getApplication().getNavigationHandler();
        handler.handleNavigation(context, fromAction, outCome);
    }

    public static void handleNoNavigation(FacesContext context) {
        NavigationHandler handler = context.getApplication().getNavigationHandler();
        handler.handleNavigation(context, null, null);
    }

    public static void redirect(FacesContext context, String path) {
        RedirectScope.setRedirectingPath(context, path);
        ExternalContext externalContext = context.getExternalContext();
        try {
            externalContext.redirect(externalContext.encodeActionURL(path));
        }
        catch (IOException e) {
            throw new FacesException(e.getMessage(), e);
        }
        context.responseComplete();
    }

    public static void assertNotAlreadyRedirect(FacesContext context) {
        if (RedirectScope.isRedirecting(context)) {
            throw new AlreadyRedirectingException();
        }
    }
}

