/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.ComponentUtil_;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.internal.ConverterResource;
import javax.faces.internal.FacesMessageUtil;
import javax.faces.internal.RenderKitUtil;
import javax.faces.internal.UIComponentUtil;
import javax.faces.internal.UIDefaultAttribute;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.IntegerConversionUtil;

public class RendererUtil {
    private static final Logger logger = Logger.getLogger((Class)RendererUtil.class);

    public static boolean containsAttributesForRender(UIComponent component, String[] attributeNames) {
        Map attributes = component.getAttributes();
        int len = attributeNames.length;
        for (int i = 0; i < len; ++i) {
            String attributeName = attributeNames[i];
            Object value = attributes.get(attributeName);
            if (!RendererUtil.shouldRenderAttribute(attributeName, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean renderAttributes(ResponseWriter writer, UIComponent component, String[] attributeNames) throws IOException {
        boolean somethingDone = false;
        int len = attributeNames.length;
        for (int i = 0; i < len; ++i) {
            String attrName = attributeNames[i];
            if (!RendererUtil.renderAttribute(writer, component, attrName)) continue;
            somethingDone = true;
        }
        return somethingDone;
    }

    static boolean renderAttribute(ResponseWriter writer, UIComponent component, String attributeName) throws IOException {
        Object value = component.getAttributes().get(attributeName);
        return RendererUtil.renderAttribute(writer, attributeName, value, attributeName);
    }

    public static void renderAttribute(ResponseWriter writer, String attributeName, Object value) throws IOException {
        RendererUtil.renderAttribute(writer, attributeName, value, attributeName);
    }

    public static boolean renderAttribute(ResponseWriter writer, String attributeName, Object value, String propertyName) throws IOException {
        if (!RendererUtil.shouldRenderAttribute(attributeName, value)) {
            return false;
        }
        attributeName = RendererUtil.toHtmlAttributeName(attributeName);
        value = RendererUtil.convertValue(attributeName, value);
        writer.writeAttribute(attributeName, value, propertyName);
        return true;
    }

    private static Object convertValue(String attributeName, Object value) {
        if ("checked".equals(attributeName)) {
            return "checked";
        }
        if ("selected".equals(attributeName)) {
            return "selected";
        }
        if ("disabled".equals(attributeName)) {
            return "disabled";
        }
        return value;
    }

    private static String toHtmlAttributeName(String attributeName) {
        if (attributeName.equalsIgnoreCase("styleClass")) {
            return "class";
        }
        if (attributeName.equalsIgnoreCase("acceptcharset")) {
            return "accept-charset";
        }
        return attributeName;
    }

    public static boolean shouldRenderAttribute(String attributeName, Object value) {
        if (RendererUtil.isDefaultAttributeValue(value)) {
            return false;
        }
        if ("colspan".equals(attributeName)) {
            Integer integerValue = IntegerConversionUtil.toInteger((Object)value);
            if (integerValue == null) {
                return false;
            }
            if (integerValue <= 1) {
                return false;
            }
        }
        if ("id".equals(attributeName)) {
            return RendererUtil.shouldRenderIdAttribute(value.toString());
        }
        return true;
    }

    static boolean isDefaultAttributeValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean) {
            return UIDefaultAttribute.isDefaultBoolean((Boolean)value);
        }
        if (value instanceof Integer) {
            return UIDefaultAttribute.isDefaultInt((Integer)value);
        }
        return false;
    }

    public static boolean shouldRenderIdAttribute(UIComponent component) {
        return RendererUtil.shouldRenderIdAttribute(component.getId());
    }

    private static boolean shouldRenderIdAttribute(String id) {
        return id != null && !id.startsWith("_id");
    }

    public static void renderIdAttributeIfNecessary(ResponseWriter writer, UIComponent component, String idValue) throws IOException {
        if (RendererUtil.shouldRenderIdAttribute(component)) {
            RendererUtil.renderAttribute(writer, "id", (Object)idValue);
        }
    }

    public static Object getConvertedValue(FacesContext context, UIInput component, Object submittedValue) {
        try {
            Renderer renderer = RendererUtil.getRenderer(context, component);
            if (renderer != null) {
                return renderer.getConvertedValue(context, component, submittedValue);
            }
            if (submittedValue instanceof String) {
                return RendererUtil.getConvertedUIOutputValue(context, component, submittedValue);
            }
        }
        catch (ConverterException e) {
            FacesMessage facesMessage = e.getFacesMessage();
            if (facesMessage != null) {
                context.addMessage(component.getClientId(context), facesMessage);
            } else {
                Object[] args = new Object[]{UIComponentUtil.getLabel(component)};
                context.addMessage(component.getClientId(context), FacesMessageUtil.getMessage(context, "javax.faces.component.UIInput.CONVERSION", args));
            }
            component.setValid(false);
        }
        return submittedValue;
    }

    static Renderer getRenderer(FacesContext context, UIComponent component) {
        String rendererType = component.getRendererType();
        if (rendererType == null) {
            return null;
        }
        RenderKit renderKit = RenderKitUtil.getRenderKit(context);
        return renderKit.getRenderer(component.getFamily(), rendererType);
    }

    public static Object getConvertedUIOutputValue(FacesContext context, UIOutput output, Object submittedValue) throws ConverterException {
        if (submittedValue == null) {
            return null;
        }
        Converter converter = RendererUtil.findConverter(context, output);
        if (converter == null) {
            return submittedValue;
        }
        return converter.getAsObject(context, output, (String)submittedValue);
    }

    public static Object getConvertedUIOutputValues(FacesContext context, UIOutput output, Object submittedValue) {
        if (submittedValue == null) {
            return null;
        }
        Converter converter = RendererUtil.findConverter(context, output);
        if (converter == null) {
            return submittedValue;
        }
        int length = Array.getLength(submittedValue);
        Class valueType = RendererUtil.getValueType(context, output);
        Object ret = Array.newInstance(valueType, length);
        for (int i = 0; i < length; ++i) {
            Object target = Array.get(submittedValue, i);
            String value = (String)target;
            Object o = converter.getAsObject(context, output, value);
            ArrayUtil.setArrayValue((Object)ret, (Class)valueType, (Object)o, (int)i);
        }
        return ret;
    }

    public static Converter findConverter(FacesContext context, UIOutput component) {
        String expression;
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueBinding vb = component.getValueBinding("value");
        if (vb != null && (converter = ConverterResource.getConverter(expression = vb.getExpressionString())) != null) {
            return converter;
        }
        Class valueType = RendererUtil.getValueType(context, component);
        if (ComponentUtil_.isPerformNoConversion(valueType)) {
            return null;
        }
        try {
            return context.getApplication().createConverter(valueType);
        }
        catch (FacesException ex) {
            logger.log((Throwable)ex);
            return null;
        }
    }

    static Class getValueType(FacesContext context, UIOutput component) {
        ValueBinding vb = component.getValueBinding("value");
        if (vb == null) {
            return null;
        }
        Class valueType = vb.getType(context);
        if (valueType == null) {
            return null;
        }
        if (valueType.isArray()) {
            return valueType.getComponentType();
        }
        return valueType;
    }

    public static void renderChild(FacesContext context, UIComponent child) throws IOException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"child", (Object)child);
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(context);
        if (child.getRendersChildren()) {
            child.encodeChildren(context);
        } else {
            RendererUtil.renderChildren(context, child);
        }
        child.encodeEnd(context);
    }

    public static void renderChildren(FacesContext context, UIComponent component) throws IOException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"child", (Object)component);
        if (component.getChildCount() > 0) {
            Iterator it = component.getChildren().iterator();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                RendererUtil.renderChild(context, child);
            }
        }
    }

    public static void renderHidden(UIComponent component, ResponseWriter writer, String name, Object value) throws IOException {
        writer.startElement("input", component);
        RendererUtil.renderAttribute(writer, "type", (Object)"hidden");
        RendererUtil.renderAttribute(writer, "name", (Object)name);
        RendererUtil.renderAttribute(writer, "value", value);
        writer.endElement("input");
    }
}

