/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.webapp;

import javax.faces.FactoryFinder;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.seasar.framework.container.servlet.S2ContainerListener;
import org.seasar.framework.log.Logger;
import org.seasar.teeda.core.ProductInfo;
import org.seasar.teeda.core.webapp.TeedaInitializer;

public class TeedaConfigureListener
extends S2ContainerListener {
    private static final String FACES_INIT_DONE = TeedaConfigureListener.class.getName() + ".FACES_INIT_DONE";
    private static Logger logger = Logger.getLogger((Class)TeedaConfigureListener.class);

    public void contextInitialized(ServletContextEvent event) {
        super.contextInitialized(event);
        this.printVersion();
        logger.debug((Object)"JSF initialize start");
        try {
            this.initializeFaces(event.getServletContext());
        }
        catch (RuntimeException e) {
            logger.log((Throwable)e);
            throw e;
        }
        logger.debug((Object)"JSF initialize end");
    }

    public void contextDestroyed(ServletContextEvent event) {
        super.contextDestroyed(event);
        FactoryFinder.releaseFactories();
    }

    protected void initializeFaces(ServletContext servletContext) {
        boolean isAlreadyInitialized;
        Boolean b = (Boolean)servletContext.getAttribute(FACES_INIT_DONE);
        boolean bl = isAlreadyInitialized = b != null ? b : false;
        if (!isAlreadyInitialized) {
            TeedaInitializer initializer = new TeedaInitializer();
            initializer.setServletContext(servletContext);
            initializer.initializeFaces();
            servletContext.setAttribute(FACES_INIT_DONE, (Object)Boolean.TRUE);
        }
    }

    private void printVersion() {
        logger.debug((Object)("Teeda version :" + ProductInfo.getVersion()));
    }
}

